/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUpdateSign;
import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.models.ExpiringSet;

public class InvalidSignUpdate
extends PacketModule {
    private final long cooldownMillis;
    private final int line_char_limit;
    private final int total_char_limit;
    private final boolean log;
    private final boolean kick;
    private ExpiringSet<UUID> cooldowns;

    public InvalidSignUpdate() {
        super("patches.sign-lag", true, PacketListenerPriority.HIGHEST, "Patches a lag exploit that involves sending specific oversized \nsign edit packets.");
        this.cooldownMillis = (long)Math.max(1, this.config.getInt(this.configPath + ".packet-delay-in-ticks", 10, "How many ticks a player needs to wait to be able to send\nanother sign update packet (renaming or writing).")) * 50L;
        this.line_char_limit = this.config.getInt(this.configPath + ".line-character-limit", 80, "Vanilla limit is 384 characters per line, which can be too much.");
        this.total_char_limit = this.config.getInt(this.configPath + ".total-char-limit", 384, "General char limit for all lines combined.");
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    @Override
    public void enable() {
        this.cooldowns = new ExpiringSet(Duration.ofMillis(this.cooldownMillis));
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
    }

    @Override
    public void disable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
        if (this.cooldowns != null) {
            this.cooldowns.clear();
            this.cooldowns.cleanUp();
            this.cooldowns = null;
        }
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() != PacketType.Play.Client.UPDATE_SIGN) {
            return;
        }
        if (this.cooldowns.contains(event.getUser().getUUID())) {
            event.setCancelled(true);
            return;
        }
        this.cooldowns.add(event.getUser().getUUID());
        int sum = 0;
        for (String line : new WrapperPlayClientUpdateSign(event).getTextLines()) {
            int chars = line.length();
            if (chars > this.line_char_limit) {
                event.setCancelled(true);
                this.onCancel(this.log, this.kick, event.getUser());
                return;
            }
            if ((sum += chars) <= this.total_char_limit) continue;
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
    }
}

