/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.util.Vector3i;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerBlockPlacement;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientQueryBlockNBT;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUpdateCommandBlock;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUpdateJigsawBlock;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientUpdateSign;
import me.xginko.aef.modules.packets.PacketModule;
import me.xginko.aef.utils.MathUtil;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class NoComExploit
extends PacketModule {
    private final double maxDistanceSquared;
    private final boolean log;
    private final boolean kick;

    public NoComExploit() {
        super("patches.prevent-nocom-coordinate-exploit", true, PacketListenerPriority.HIGHEST, "Prevents the abusable mechanic used by the infamous \"No Comment\"\ncoordinate exploit, where the server responds to requests that are\nfar outside of the sending player's reach, therefore either crashing\nor revealing positions loaded by other players.\nMore info on NoCom: https://github.com/nerdsinspace/nocom-explanation/blob/main/README.md\nThis is still useful to keep enabled even if your version is not\naffected by the NoCom vulnerability.");
        this.maxDistanceSquared = MathUtil.square(this.config.getInt(this.configPath + ".max-distance", 24));
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        Vector3i blockPos;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() == PacketType.Play.Client.PLAYER_DIGGING) {
            blockPos = new WrapperPlayClientPlayerDigging(event).getBlockPosition();
        } else if (event.getPacketType() == PacketType.Play.Client.PLAYER_BLOCK_PLACEMENT) {
            blockPos = new WrapperPlayClientPlayerBlockPlacement(event).getBlockPosition();
        } else if (event.getPacketType() == PacketType.Play.Client.UPDATE_SIGN) {
            blockPos = new WrapperPlayClientUpdateSign(event).getBlockPosition();
        } else if (event.getPacketType() == PacketType.Play.Client.QUERY_BLOCK_NBT) {
            blockPos = new WrapperPlayClientQueryBlockNBT(event).getBlockPosition();
        } else if (event.getPacketType() == PacketType.Play.Client.UPDATE_COMMAND_BLOCK) {
            blockPos = new WrapperPlayClientUpdateCommandBlock(event).getPosition();
        } else if (event.getPacketType() == PacketType.Play.Client.UPDATE_JIGSAW_BLOCK) {
            blockPos = new WrapperPlayClientUpdateJigsawBlock(event).getPosition();
        } else {
            return;
        }
        if (blockPos.x == 0 && blockPos.y == 0 && blockPos.z == 0) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        if (this.distanceSquared(blockPos, ((Entity)event.getPlayer()).getLocation()) > this.maxDistanceSquared) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
        }
    }

    private double distanceSquared(Vector3i packetPos, Location playerPos) {
        return MathUtil.square((double)packetPos.x - playerPos.getX(), (double)packetPos.y - playerPos.getY(), (double)packetPos.z - playerPos.getZ());
    }
}

