/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.PacketEvents;
import com.github.retrooper.packetevents.event.PacketListener;
import com.github.retrooper.packetevents.event.PacketListenerAbstract;
import com.github.retrooper.packetevents.event.PacketListenerCommon;
import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.protocol.player.User;
import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.models.ExpiringSet;
import me.xginko.aef.utils.models.Lazy;

public abstract class PacketModule
extends AEFModule
implements PacketListener {
    protected final PacketListenerAbstract asAbstract;
    protected final Lazy<ExpiringSet<UUID>> loggingCooldown;

    public PacketModule(String configPath, boolean enabledByDefault, PacketListenerPriority priority) {
        this(configPath, enabledByDefault, priority, null);
    }

    public PacketModule(String configPath, boolean enabledByDefault, PacketListenerPriority priority, String comment) {
        super(configPath, enabledByDefault, comment);
        this.asAbstract = this.asAbstract(priority);
        this.loggingCooldown = Lazy.of(() -> new ExpiringSet(Duration.ofMinutes(5L)));
    }

    @Override
    public void enable() {
        PacketEvents.getAPI().getEventManager().registerListener((PacketListenerCommon)this.asAbstract);
    }

    @Override
    public void disable() {
        PacketEvents.getAPI().getEventManager().unregisterListener((PacketListenerCommon)this.asAbstract);
    }

    public void onCancel(boolean log, boolean kick, User sender) {
        if (log && !this.loggingCooldown.get().contains(sender.getUUID())) {
            this.info(sender.getName() + " failed to trigger exploit.");
            this.loggingCooldown.get().add(sender.getUUID());
        }
        if (kick) {
            sender.closeConnection();
        }
    }
}

