/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientTabComplete;
import java.util.List;
import me.xginko.aef.modules.packets.PacketModule;
import org.bukkit.permissions.ServerOperator;

public class TabCompleteCrash
extends PacketModule {
    private final String[] sequences;
    private final boolean log;
    private final boolean kick;

    public TabCompleteCrash() {
        super("patches.tab-complete-crash-patch", true, PacketListenerPriority.HIGHEST, "Patches two lag exploits and an instant server shutdown exploit that \nworks by sending a malicious TabComplete packet that triggers a \nStackOverflowError inside the TagParser class.");
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
        this.sequences = this.config.getList(this.configPath + ".characters", List.of("@", "[", "nbt", "=", "{", "}", "]")).toArray(new String[0]);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        int index;
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() != PacketType.Play.Client.TAB_COMPLETE) {
            return;
        }
        String text = new WrapperPlayClientTabComplete(event).getText();
        int length = text.length();
        if (length > 256) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
        if (length > 64 && ((index = text.indexOf(32)) == -1 || index >= 64)) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
        if (event.getPlayer() != null && ((ServerOperator)event.getPlayer()).isOp()) {
            return;
        }
        for (String sequence : this.sequences) {
            if (!text.contains(sequence)) continue;
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
    }
}

