/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.packets;

import com.github.retrooper.packetevents.event.PacketListenerPriority;
import com.github.retrooper.packetevents.event.PacketReceiveEvent;
import com.github.retrooper.packetevents.protocol.packettype.PacketType;
import com.github.retrooper.packetevents.wrapper.play.client.WrapperPlayClientClickWindow;
import me.xginko.aef.modules.packets.PacketModule;
import org.bukkit.entity.HumanEntity;

public class WindowClickCrash
extends PacketModule {
    private final boolean log;
    private final boolean kick;

    public WindowClickCrash() {
        super("patches.window-click-crash-patch", true, PacketListenerPriority.HIGHEST, "Patches a variety of different lag and crash methods that work \nby sending invalid Window Click packets, causing the server to \ndump error logs until it runs out of memory.");
        this.log = this.config.getBoolean(this.configPath + ".log", false);
        this.kick = this.config.getBoolean(this.configPath + ".kick-player", false);
    }

    public void onPacketReceive(PacketReceiveEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (event.getPacketType() != PacketType.Play.Client.CLICK_WINDOW) {
            return;
        }
        WrapperPlayClientClickWindow packet = new WrapperPlayClientClickWindow(event);
        int button = packet.getButton();
        if (button < 0 || button > 10 && button != 40 && button != 99) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
        int slot = packet.getSlot();
        if (event.getPlayer() != null && ((HumanEntity)event.getPlayer()).getOpenInventory().countSlots() < slot) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
        if (slot != -999 && slot != -1) {
            if (slot < 0) {
                event.setCancelled(true);
                this.onCancel(this.log, this.kick, event.getUser());
            }
            return;
        }
        if (button == 40) {
            event.setCancelled(true);
            this.onCancel(this.log, this.kick, event.getUser());
            return;
        }
        switch (packet.getWindowClickType()) {
            case SWAP: 
            case PICKUP_ALL: {
                event.setCancelled(true);
                this.onCancel(this.log, this.kick, event.getUser());
                break;
            }
            case THROW: {
                if (slot != -1) break;
                event.setCancelled(true);
                this.onCancel(this.log, this.kick, event.getUser());
                break;
            }
            case QUICK_MOVE: {
                if (slot != -999) break;
                event.setCancelled(true);
                this.onCancel(this.log, this.kick, event.getUser());
            }
        }
    }
}

