/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.patches;

import com.destroystokyo.paper.event.player.PlayerPostRespawnEvent;
import com.github.retrooper.packetevents.manager.server.ServerVersion;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MathUtil;
import me.xginko.aef.utils.enums.Platform;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class TeleportCoordExploit
extends AEFModule
implements Listener {
    private final Set<PlayerTeleportEvent.TeleportCause> ignoredCauses;
    private final long teleportVanishTime;
    private final double minDistanceSquared;

    public TeleportCoordExploit() {
        super("patches.prevent-teleport-coordinate-exploit", true, "Patches coordinate exploit for teleportation commands such as /tpa,\n/home AS WELL as respawn exploits. \nThis is done by vanishing the player for x ticks before teleporting.");
        this.minDistanceSquared = MathUtil.square(this.config.getInt(this.configPath + ".min-distance-to-vanish-player", 100));
        this.teleportVanishTime = this.config.getInt(this.configPath + ".teleport-vanish-time-in-ticks", 10);
        this.ignoredCauses = this.config.getList(this.configPath + ".ignored-teleport-causes", Arrays.asList("NETHER_PORTAL", "END_PORTAL", "END_GATEWAY", "EXIT_BED", "DISMOUNT", Platform.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? "CONSUMABLE_EFFECT" : "CHORUS_FRUIT"), "TeleportCauses unaffected by this module.\nSee: https://jd.papermc.io/paper/1.21.5/org/bukkit/event/player/PlayerTeleportEvent.TeleportCause.html").stream().map(configuredCause -> {
            try {
                return PlayerTeleportEvent.TeleportCause.valueOf((String)configuredCause);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(PlayerTeleportEvent.TeleportCause.class)));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    private void tempVanish(Player player) {
        UUID vanishedUUID = player.getUniqueId();
        for (Player onlinePlayer : this.plugin.getServer().getOnlinePlayers()) {
            if (onlinePlayer.getUniqueId().equals(vanishedUUID)) continue;
            onlinePlayer.getScheduler().execute((Plugin)this.plugin, () -> {
                onlinePlayer.hidePlayer((Plugin)this.plugin, player);
                onlinePlayer.getScheduler().execute((Plugin)this.plugin, () -> onlinePlayer.showPlayer((Plugin)this.plugin, player), null, this.teleportVanishTime);
            }, null, 1L);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onTeleport(PlayerTeleportEvent event) {
        if (this.ignoredCauses.contains(event.getCause())) {
            return;
        }
        if (LocationUtil.getRelativeSquaredDistance2D(event.getFrom(), event.getTo()) >= this.minDistanceSquared) {
            this.tempVanish(event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onSpawn(PlayerPostRespawnEvent event) {
        if (LocationUtil.getRelativeSquaredDistance2D(event.getPlayer().getLocation(), event.getRespawnLocation()) >= this.minDistanceSquared) {
            this.tempVanish(event.getPlayer());
        }
    }
}

