/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.models.Lazy;
import me.xginko.aef.utils.permissions.AEFPermission;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class HeightLimits
extends AEFModule
implements Listener {
    private final Map<String, WorldHeightLimit> worldHeightLimits;
    private final Material fillMaterial;
    private final int teleportDistance;
    private final boolean doSafeTeleport;
    private final boolean fillAnyHoles;
    private final boolean doTeleports;
    private final double playerDamageOnMove;

    public HeightLimits() {
        super("preventions.height-limits", true, "Prevent players from going above nether roof or bedrock floor.");
        this.playerDamageOnMove = this.config.getDouble(this.configPath + ".damage-when-moving", 6.0, "1.0 = Half a heart of damage every time you move. Set 0 to disable\nOnly damages players");
        this.doTeleports = this.config.getBoolean(this.configPath + ".teleports.enable", true, "Should we teleport at all?");
        this.teleportDistance = this.config.getInt(this.configPath + ".teleports.distance", 10, "Distance in blocks the player will be teleported back from the set limit");
        this.doSafeTeleport = this.config.getBoolean(this.configPath + ".teleports.ensure-safe-teleports", true, "Ensures players are not just teleported into walls or lava");
        this.fillAnyHoles = this.config.getBoolean(this.configPath + ".fill-holes.enable", true, "Fill any holes that may be open with the configured material");
        String configuredFillMaterial = this.config.getString(this.configPath + ".fill-holes.material", "BEDROCK");
        Material filler_material = Material.BEDROCK;
        try {
            filler_material = Material.valueOf((String)configuredFillMaterial);
        }
        catch (IllegalArgumentException e) {
            this.notRecognized(Material.class, configuredFillMaterial);
        }
        this.fillMaterial = filler_material;
        String sectionPath = this.configPath + ".worlds";
        this.config.master().makeSectionLenient(sectionPath);
        this.config.master().addExample(sectionPath + ".world.y-limit.upper", 500);
        this.config.master().addExample(sectionPath + ".world.y-limit.lower", -64);
        this.config.master().addExample(sectionPath + ".world_nether.y-limit.upper", 127);
        this.config.master().addExample(sectionPath + ".world_nether.y-limit.lower", 0);
        this.config.master().addExample(sectionPath + ".world_the_end.y-limit.upper", 500);
        this.config.master().addExample(sectionPath + ".world_the_end.y-limit.lower", 0);
        ConfigSection limitsSection = this.config.master().getConfigSection(sectionPath);
        List<String> worlds = limitsSection.getKeys(false);
        this.worldHeightLimits = new HashMap<String, WorldHeightLimit>(worlds.size());
        for (String world : worlds) {
            this.worldHeightLimits.put(world, new WorldHeightLimit(this.config.master().getInteger(sectionPath + "." + world + ".y-limit.upper", 500), this.config.master().getInteger(sectionPath + "." + world + ".y-limit.lower", 0)));
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    private PositionStatus getPositionStatus(Location location) {
        if (!this.worldHeightLimits.containsKey(location.getWorld().getName())) {
            return PositionStatus.WITHIN_BOUNDS;
        }
        WorldHeightLimit heightLimit = this.worldHeightLimits.get(location.getWorld().getName());
        if (location.getY() > (double)heightLimit.upperLimit) {
            return PositionStatus.ABOVE_UPPER_LIMIT;
        }
        if (location.getY() < (double)heightLimit.lowerLimit) {
            return PositionStatus.BELOW_LOWER_LIMIT;
        }
        return PositionStatus.WITHIN_BOUNDS;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerTeleport(PlayerTeleportEvent event) {
        PositionStatus playerStatus;
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), AEFPermission.BYPASS_HEIGHT_LIMITS.node()).toBoolean()) {
            return;
        }
        if (this.getPositionStatus(event.getTo()) != PositionStatus.WITHIN_BOUNDS) {
            event.setCancelled(true);
        }
        if ((playerStatus = this.getPositionStatus(event.getPlayer().getLocation())) == PositionStatus.WITHIN_BOUNDS) {
            return;
        }
        if (this.playerDamageOnMove > 0.0) {
            event.getPlayer().damage(this.playerDamageOnMove);
        }
        if (this.doTeleports) {
            event.getPlayer().getScheduler().run((Plugin)this.plugin, (Consumer)new PositionCorrection(this, (Entity)event.getPlayer(), playerStatus), null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onBlockPlace(BlockPlaceEvent event) {
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), AEFPermission.BYPASS_HEIGHT_LIMITS.node()).toBoolean()) {
            return;
        }
        if (this.getPositionStatus(event.getBlock().getLocation()) != PositionStatus.WITHIN_BOUNDS) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPlayerMove(PlayerMoveEvent event) {
        if (AnarchyExploitFixes.permissions().permissionValue((Permissible)event.getPlayer(), AEFPermission.BYPASS_HEIGHT_LIMITS.node()).toBoolean()) {
            return;
        }
        PositionStatus playerStatus = this.getPositionStatus(event.getPlayer().getLocation());
        if (playerStatus == PositionStatus.WITHIN_BOUNDS) {
            return;
        }
        if (this.playerDamageOnMove > 0.0) {
            event.getPlayer().damage(this.playerDamageOnMove);
        }
        if (this.doTeleports) {
            event.setCancelled(true);
            event.getPlayer().getScheduler().run((Plugin)this.plugin, (Consumer)new PositionCorrection(this, (Entity)event.getPlayer(), playerStatus), null);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onVehicleMove(VehicleMoveEvent event) {
        for (Entity passenger : event.getVehicle().getPassengers()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            if (!AnarchyExploitFixes.permissions().permissionValue((Permissible)player, AEFPermission.BYPASS_HEIGHT_LIMITS.node()).toBoolean()) continue;
            return;
        }
        for (Entity passenger : event.getVehicle().getPassengers()) {
            PositionStatus passengerStatus = this.getPositionStatus(passenger.getLocation());
            if (passengerStatus == PositionStatus.WITHIN_BOUNDS) continue;
            if (this.playerDamageOnMove > 0.0 && passenger.getType() == XEntityType.PLAYER.get()) {
                ((Player)passenger).damage(this.playerDamageOnMove);
            }
            if (!this.doTeleports) continue;
            passenger.getScheduler().run((Plugin)this.plugin, (Consumer)new PositionCorrection(this, passenger, passengerStatus), null);
        }
        PositionStatus vehicleStatus = this.getPositionStatus(event.getVehicle().getLocation());
        if (vehicleStatus != PositionStatus.WITHIN_BOUNDS) {
            if (this.doTeleports) {
                event.getVehicle().getScheduler().run((Plugin)this.plugin, (Consumer)new PositionCorrection(this, (Entity)event.getVehicle(), vehicleStatus), null);
            } else {
                event.getVehicle().remove();
            }
        }
    }

    private record WorldHeightLimit(int upperLimit, int lowerLimit) {
    }

    private static enum PositionStatus {
        ABOVE_UPPER_LIMIT,
        BELOW_LOWER_LIMIT,
        WITHIN_BOUNDS;

    }

    private static class PositionCorrection
    implements Consumer<ScheduledTask> {
        private final HeightLimits heightLimits;
        private final Entity entity;
        private final PositionStatus positionStatus;
        private static final Lazy<Set<BlockFace>> CARDINAL_FACES = Lazy.of(() -> EnumSet.of(BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST));

        public PositionCorrection(HeightLimits heightLimits, Entity entity, PositionStatus positionStatus) {
            this.heightLimits = heightLimits;
            this.entity = entity;
            this.positionStatus = positionStatus;
        }

        @Override
        public void accept(ScheduledTask scheduledTask) {
            Block blockAtEntity;
            Entity entity = this.entity;
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.setGliding(false);
            }
            this.entity.leaveVehicle();
            if (this.heightLimits.fillAnyHoles && (blockAtEntity = this.entity.getWorld().getBlockAt(this.entity.getLocation().getBlockX(), this.positionStatus == PositionStatus.ABOVE_UPPER_LIMIT ? this.heightLimits.worldHeightLimits.get((Object)this.entity.getWorld().getName()).upperLimit : this.heightLimits.worldHeightLimits.get((Object)this.entity.getWorld().getName()).lowerLimit, this.entity.getLocation().getBlockZ())).getType() != this.heightLimits.fillMaterial) {
                blockAtEntity.setType(this.heightLimits.fillMaterial);
            }
            Location correctedLocation = LocationUtil.toXZCenter(this.entity.getLocation()).add(0.0, this.positionStatus == PositionStatus.ABOVE_UPPER_LIMIT ? (double)(-this.heightLimits.teleportDistance) : (double)this.heightLimits.teleportDistance, 0.0);
            this.entity.teleportAsync(correctedLocation).thenAccept(teleportSuccess -> {
                if (!teleportSuccess.booleanValue() || !this.heightLimits.doSafeTeleport) {
                    return;
                }
                this.entity.getScheduler().run((Plugin)this.heightLimits.plugin, ensureSafeTeleport -> {
                    Block blockAtPlayerTorso;
                    Block blockAtPlayerLegs;
                    Block blockAboveHead = correctedLocation.clone().add(0.0, 2.0, 0.0).getBlock();
                    if (PositionCorrection.needsFilling(blockAboveHead) && blockAboveHead.getType() != XMaterial.NETHER_PORTAL.get()) {
                        blockAboveHead.setType(XMaterial.DIRT.get(), false);
                    }
                    if (!(blockAtPlayerLegs = correctedLocation.getBlock()).getType().isAir() && blockAtPlayerLegs.getType() != XMaterial.NETHER_PORTAL.get()) {
                        blockAtPlayerLegs.setType(XMaterial.AIR.get(), false);
                    }
                    if (!(blockAtPlayerTorso = blockAtPlayerLegs.getRelative(BlockFace.UP)).getType().isAir() && blockAtPlayerTorso.getType() != XMaterial.NETHER_PORTAL.get()) {
                        blockAtPlayerTorso.setType(XMaterial.AIR.get(), false);
                    }
                    for (int i = 0; i < 2; ++i) {
                        Block airPocketBlock = blockAtPlayerLegs.getRelative(BlockFace.UP, i);
                        for (BlockFace face : CARDINAL_FACES.get()) {
                            Block around = airPocketBlock.getRelative(face);
                            if (!PositionCorrection.needsFilling(around)) continue;
                            around.setType(XMaterial.DIRT.get(), false);
                        }
                    }
                    Block blockBelowFeet = blockAtPlayerLegs.getRelative(BlockFace.DOWN);
                    if (PositionCorrection.needsFilling(blockBelowFeet) || blockBelowFeet.getType() == XMaterial.NETHER_PORTAL.get()) {
                        blockBelowFeet.setType(XMaterial.DIRT.get(), true);
                    }
                }, null);
            });
        }

        private static boolean needsFilling(Block block) {
            return block.getType() == XMaterial.LAVA.get() || block.getType() != XMaterial.WATER.get() && block.getType().hasGravity() || !block.isSolid();
        }
    }
}

