/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class IllegalGameMode
extends AEFModule
implements Consumer<ScheduledTask>,
Listener {
    private final Map<String, GameMode> worldSettings;
    private final Set<String> allowedGamemodePlayers;
    private final GameMode defaultGamemode;
    private final long checkPeriodMillis;
    private final boolean shouldLog;
    private ScheduledTask scheduledCheck;

    public IllegalGameMode() {
        super("preventions.illegal-gamemode", false, "Forces GameMode for players not in the whitelist. \nUseful protection against past and future backdoor incidents");
        GameMode gameMode;
        this.shouldLog = this.config.getBoolean(this.configPath + ".log", true);
        this.checkPeriodMillis = this.config.getLong(this.configPath + ".check-period-millis", 5000L, "How often to (asynchronously) check all online players\nfor illegal GameMode in milliseconds.");
        String configuredGamemode = this.config.getString(this.configPath + ".default-gamemode", GameMode.SURVIVAL.name(), "GameModes: " + Arrays.stream(GameMode.values()).map(Enum::name).collect(Collectors.joining(", ")));
        try {
            gameMode = GameMode.valueOf((String)configuredGamemode);
        }
        catch (IllegalArgumentException e) {
            this.notRecognized(GameMode.class, configuredGamemode);
            gameMode = GameMode.SURVIVAL;
        }
        this.defaultGamemode = gameMode;
        HashMap<String, Object> defaults = new HashMap<String, Object>(3);
        defaults.put("world", GameMode.SURVIVAL.name());
        defaults.put("world_nether", GameMode.SURVIVAL.name());
        defaults.put("world_the_end", GameMode.SURVIVAL.name());
        ConfigSection section = this.config.getConfigSection(this.configPath + ".world-gamemodes", defaults);
        List<String> worlds = section.getKeys(false);
        this.worldSettings = new HashMap<String, GameMode>(worlds.size());
        for (String world : worlds) {
            try {
                this.worldSettings.put(world, GameMode.valueOf((String)section.getString(world)));
            }
            catch (IllegalArgumentException e) {
                this.notRecognized(GameMode.class, world);
            }
        }
        this.allowedGamemodePlayers = new HashSet<String>(this.config.getList(this.configPath + ".whitelisted-players", List.of("Notch")));
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
        this.scheduledCheck = this.plugin.getServer().getAsyncScheduler().runAtFixedRate((Plugin)this.plugin, (Consumer)this, 1L, this.checkPeriodMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.scheduledCheck != null) {
            this.scheduledCheck.cancel();
            this.scheduledCheck = null;
        }
    }

    @Override
    public void accept(ScheduledTask scheduledTask) {
        for (Player player : this.plugin.getServer().getOnlinePlayers()) {
            this.checkForIllegalGameMode((HumanEntity)player);
        }
    }

    private void checkForIllegalGameMode(HumanEntity player) {
        if (this.allowedGamemodePlayers.contains(player.getName())) {
            return;
        }
        GameMode targetGamemode = this.worldSettings.getOrDefault(player.getWorld().getName(), this.defaultGamemode);
        if (player.getGameMode() == targetGamemode) {
            return;
        }
        if (this.shouldLog) {
            this.warn(player.getName() + " is GameMode " + player.getGameMode().name() + " at " + LocationUtil.toString(player.getLocation()) + ". Setting to " + targetGamemode.name());
        }
        player.getScheduler().execute((Plugin)this.plugin, () -> player.setGameMode(targetGamemode), null, 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onGameModeChange(PlayerGameModeChangeEvent event) {
        if (this.allowedGamemodePlayers.contains(event.getPlayer().getName())) {
            return;
        }
        if (event.getNewGameMode() != this.worldSettings.getOrDefault(event.getPlayer().getWorld().getName(), this.defaultGamemode)) {
            if (this.shouldLog) {
                this.warn(event.getPlayer().getName() + " tried to change to GameMode " + event.getNewGameMode().name() + " at " + LocationUtil.toString(event.getPlayer().getLocation()));
            }
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onJoin(PlayerJoinEvent event) {
        this.checkForIllegalGameMode((HumanEntity)event.getPlayer());
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onChangedWorld(PlayerChangedWorldEvent event) {
        this.checkForIllegalGameMode((HumanEntity)event.getPlayer());
    }
}

