/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.blockbreak;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.plugin.Plugin;

public class PistonExplodePermBlockRemoval
extends AEFModule
implements Listener {
    private final Set<String> whitelistedWorlds;

    public PistonExplodePermBlockRemoval() {
        super("preventions.permanent-block-breaking.by-exploding-pistons", true);
        this.whitelistedWorlds = new HashSet<String>(this.config.getList(this.configPath + ".whitelisted-worlds", List.of("example_world_name")));
        this.config.getBoolean(this.configPath + ".only-for-portals-and-gateways", false, "If enabled, will only protect portals and end gateways");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntityExplode(EntityExplodeEvent event) {
        if (this.whitelistedWorlds.contains(event.getEntity().getWorld().getName())) {
            return;
        }
        event.blockList().removeIf(block -> {
            if (!MaterialUtil.PISTONS.get().contains(block.getType())) {
                return false;
            }
            for (BlockFace face : BlockFace.values()) {
                if (!MaterialUtil.INDESTRUCTIBLES.get().contains(block.getRelative(face).getType())) continue;
                this.plugin.getServer().getRegionScheduler().runDelayed((Plugin)this.plugin, block.getLocation(), remove -> block.setType(XMaterial.AIR.get()), 5L);
                return true;
            }
            return false;
        });
    }
}

