/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.blockbreak;

import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import me.xginko.aef.utils.MaterialUtil;
import org.bukkit.block.BlockState;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;

public class StructureGrowPermBlockRemoval
extends AEFModule
implements Listener {
    public StructureGrowPermBlockRemoval() {
        super("preventions.permanent-block-breaking.by-growing-structures", true, "Prevents removal of permanent blocks by growing structures \nlike mushrooms into them.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        for (BlockState blockState : event.getBlocks()) {
            if (!MaterialUtil.INDESTRUCTIBLES.get().contains(blockState.getLocation().getBlock().getType())) continue;
            event.setCancelled(true);
            this.info("Prevented permanent block break by " + event.getSpecies().name() + " at " + LocationUtil.toString(blockState.getLocation()));
            return;
        }
    }
}

