/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.portals;

import java.time.Duration;
import java.util.UUID;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.libs.xseries.XSound;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.enums.Platform;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPortalEnterEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.plugin.Plugin;

public class PreventPortalTraps
extends AEFModule
implements Listener {
    private final Cache<UUID, Location> portalEnterLocations;
    private final long tpBackDelayTicks;

    public PreventPortalTraps() {
        super("preventions.portals.prevent-portal-traps", false, "Teleports a player back to the original location if they have been \nstanding in a portal for too long.");
        int tpBackDelaySeconds = Math.max(1, this.config.getInt(this.configPath + ".wait-time-until-tp-back-in-seconds", 10));
        this.tpBackDelayTicks = (long)tpBackDelaySeconds * 20L;
        this.portalEnterLocations = Platform.FOLIA.isPresent() ? Caffeine.newBuilder().expireAfterWrite(Duration.ofSeconds(tpBackDelaySeconds + 2)).build() : null;
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPortalUse(PlayerPortalEvent event) {
        Player player = event.getPlayer();
        player.getScheduler().execute((Plugin)this.plugin, () -> {
            if (player.getLocation().getBlock().getType() == XMaterial.NETHER_PORTAL.get()) {
                player.teleportAsync(event.getFrom()).thenAccept(tpHappened -> {
                    if (tpHappened.booleanValue()) {
                        player.playSound(player.getLocation(), (Sound)XSound.BLOCK_PORTAL_TRAVEL.get(), 1.0f, 1.0f);
                    }
                });
            }
        }, null, this.tpBackDelayTicks);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onPortalEnter(EntityPortalEnterEvent event) {
        if (!Platform.FOLIA.isPresent()) {
            return;
        }
        if (event.getEntityType() != EntityType.PLAYER) {
            return;
        }
        Player player = (Player)event.getEntity();
        Location firstEnterLoc = this.portalEnterLocations.getIfPresent(player.getUniqueId());
        if (firstEnterLoc != null) {
            return;
        }
        Location from = player.getLocation();
        this.portalEnterLocations.put(player.getUniqueId(), from);
        player.getScheduler().execute((Plugin)this.plugin, () -> {
            if (player.getLocation().getBlock().getType() == XMaterial.NETHER_PORTAL.get()) {
                player.teleportAsync(from).thenAccept(tpHappened -> {
                    if (tpHappened.booleanValue()) {
                        player.playSound(player.getLocation(), (Sound)XSound.BLOCK_PORTAL_TRAVEL.get(), 1.0f, 1.0f);
                    }
                });
            }
        }, null, this.tpBackDelayTicks);
    }
}

