/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.withers;

import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.modules.AEFModule;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.plugin.Plugin;

public class RemoveSkullsOnChunkload
extends AEFModule
implements Listener {
    public RemoveSkullsOnChunkload() {
        super("preventions.withers.remove-skulls-on-load", true, "Removes wither skulls when entities get loaded. \nUse if you have a ton of them at spawn and they are causing lag.");
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onProjectileLaunch(ProjectileLaunchEvent event) {
        if (event.getEntityType() == XEntityType.WITHER_SKULL.get()) {
            event.getEntity().setPersistent(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onEntitiesLoad(EntitiesLoadEvent event) {
        for (Entity entity : event.getEntities()) {
            if (entity.getType() != XEntityType.WITHER_SKULL.get()) continue;
            entity.getScheduler().execute((Plugin)this.plugin, () -> ((Entity)entity).remove(), null, 1L);
        }
    }
}

