/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.modules.preventions.withers;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import me.xginko.aef.AnarchyExploitFixes;
import me.xginko.aef.libs.configmaster.api.ConfigSection;
import me.xginko.aef.modules.AEFModule;
import me.xginko.aef.utils.LocationUtil;
import net.kyori.adventure.text.TextReplacementConfig;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.NumberConversions;

public class WitherSummonAtSpawn
extends AEFModule
implements Listener {
    private final Map<String, Double> worldsAndTheirRadiuses;
    private final boolean playersShouldBeInformed;

    public WitherSummonAtSpawn() {
        super("preventions.withers.disable-summon-at-spawn", false, "Disables spawning withers near a configurable radius around \nspawn. Helps if players are generating endless amounts of withers \nto lag the server.");
        this.playersShouldBeInformed = this.config.getBoolean(this.configPath + ".inform-players", true);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("world", 5000);
        defaults.put("world_nether", 5000);
        defaults.put("world_the_end", 5000);
        ConfigSection section = this.config.getConfigSection(this.configPath + ".worlds", defaults);
        List<String> worlds = section.getKeys(false);
        this.worldsAndTheirRadiuses = new HashMap<String, Double>(worlds.size());
        for (String world : worlds) {
            try {
                Double radiusSquared = NumberConversions.square((double)Integer.parseInt(section.getString(world)));
                this.worldsAndTheirRadiuses.put(world, radiusSquared);
            }
            catch (NumberFormatException e) {
                this.warn("Radius for world '" + world + "' is not a valid integer.");
            }
        }
    }

    @Override
    public void enable() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void onCreatureSpawn(CreatureSpawnEvent event) {
        if (event.getSpawnReason() != CreatureSpawnEvent.SpawnReason.BUILD_WITHER) {
            return;
        }
        String worldName = event.getLocation().getWorld().getName();
        if (!this.worldsAndTheirRadiuses.containsKey(worldName)) {
            return;
        }
        if (LocationUtil.getSquaredDistance2DTo00(event.getLocation()) > this.worldsAndTheirRadiuses.get(worldName)) {
            return;
        }
        event.setCancelled(true);
        if (this.playersShouldBeInformed) {
            for (Player nearbyPlayer : event.getLocation().getNearbyPlayers(8.0)) {
                nearbyPlayer.sendMessage(AnarchyExploitFixes.translation((Locale)nearbyPlayer.locale()).preventions_witherSpawningDisabledInRadius.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%radius%").replacement(this.worldsAndTheirRadiuses.get(worldName).toString()).build()));
            }
        }
    }
}

