/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import java.util.List;
import me.xginko.aef.libs.xseries.XMaterial;
import me.xginko.aef.utils.DataComponentUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BundleMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class BundleUtil {
    public static final boolean BUNDLES_SUPPPORTED = XMaterial.BUNDLE.isSupported() && ReflectionUtil.hasClass("org.bukkit.inventory.meta.BundleMeta");

    @Nullable
    public static @Unmodifiable List<ItemStack> getBundleContent(@NotNull ItemStack itemStack) {
        List<ItemStack> content;
        if (DataComponentUtil.COMPONENTS_SUPPORTED && (content = DataComponentUtil.getBundleContent(itemStack)) != null) {
            return content;
        }
        if (MaterialUtil.BUNDLES.get().contains(itemStack.getType()) && itemStack.hasItemMeta()) {
            return ((BundleMeta)itemStack.getItemMeta()).getItems();
        }
        return null;
    }

    public static boolean isBundle(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return BundleUtil.isBundle(itemStack.getType()) || DataComponentUtil.COMPONENTS_SUPPORTED && DataComponentUtil.hasBundleContent(itemStack);
    }

    public static boolean isBundle(@NotNull Material material) {
        return MaterialUtil.BUNDLES.get().contains(material);
    }
}

