/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.util.NumberConversions;

public final class ChunkUtil {
    private static final boolean SET_FORCE_LOADED_AVAILABLE = ReflectionUtil.hasMethod(Chunk.class, "setForceLoaded", Boolean.TYPE);
    private static final boolean GET_INHABITED_TIME_AVAILABLE = ReflectionUtil.hasMethod(Chunk.class, "getInhabitedTime", new Class[0]);
    private static final boolean IS_ENTITIES_LOADED_AVAILABLE = ReflectionUtil.hasMethod(Chunk.class, "isEntitiesLoaded", new Class[0]);

    public static boolean canSetChunksForceLoaded() {
        return SET_FORCE_LOADED_AVAILABLE;
    }

    public static void setForceLoaded(Chunk chunk, boolean forced) {
        if (SET_FORCE_LOADED_AVAILABLE) {
            chunk.setForceLoaded(forced);
        }
    }

    public static boolean canGetInhabitedTime() {
        return GET_INHABITED_TIME_AVAILABLE;
    }

    public static long getInhabitedTime(Chunk chunk) {
        return GET_INHABITED_TIME_AVAILABLE ? chunk.getInhabitedTime() : -1L;
    }

    public static boolean isRetrievalUnsafe(Chunk chunk) {
        return chunk.getX() > 1875000 || chunk.getZ() > 1875000 || chunk.getX() < -1875000 || chunk.getZ() < -1875000;
    }

    public static boolean isEntitiesLoaded(Chunk chunk) {
        return IS_ENTITIES_LOADED_AVAILABLE ? chunk.isEntitiesLoaded() : chunk.isLoaded();
    }

    public static void setLayerOf(Material material, int y, Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.getBlock(x, y, z).setType(material, false);
            }
        }
    }

    public static double getChunkDistanceSquared(Chunk chunk1, Chunk chunk2) {
        return NumberConversions.square((double)(chunk1.getX() - chunk2.getX())) + NumberConversions.square((double)(chunk1.getZ() - chunk2.getZ()));
    }

    public static double getChunkDistanceSquared(Chunk chunk, Location location) {
        return NumberConversions.square((double)(chunk.getX() - (location.getBlockX() >> 4))) + NumberConversions.square((double)(chunk.getZ() - (location.getBlockZ() >> 4)));
    }

    public static double getChunkDistanceSquared(Location location1, Location location2) {
        return NumberConversions.square((double)((location1.getBlockX() >> 4) - (location2.getBlockX() >> 4))) + NumberConversions.square((double)((location1.getBlockZ() >> 4) - (location2.getBlockZ() >> 4)));
    }
}

