/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.xginko.aef.libs.xseries.XEntityType;
import me.xginko.aef.libs.xseries.base.XBase;
import me.xginko.aef.utils.models.Lazy;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Vehicle;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;

public final class EntityUtil {
    public static final boolean IS_SWIMMING_AVAILABLE = ReflectionUtil.hasMethod(LivingEntity.class, "isSwimming", Boolean.TYPE);
    public static final boolean SET_PERSISTENT_AVAILABLE = ReflectionUtil.hasMethod(Entity.class, "setPersistent", Boolean.TYPE);
    public static final boolean ITEM_GET_HEALTH_AVAILABLE = ReflectionUtil.hasMethod(Item.class, "getHealth", Integer.TYPE);
    public static final Lazy<Set<EntityType>> MINECARTS = Lazy.of(() -> Arrays.stream(XEntityType.values()).filter(xEntityType -> xEntityType.name().toUpperCase().contains("MINECART")).filter(XBase::isSupported).map(XEntityType::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class))));
    public static final Lazy<Set<EntityType>> ITEM_FRAMES = Lazy.of(() -> Arrays.stream(XEntityType.values()).filter(xEntityType -> xEntityType.name().toUpperCase().contains("ITEM_FRAME")).filter(XBase::isSupported).map(XEntityType::get).collect(Collectors.toCollection(() -> EnumSet.noneOf(EntityType.class))));
    private static final Lazy<Map<EntityType, Boolean>> IS_INVHOLDER_CACHE = Lazy.of(() -> new EnumMap(EntityType.class));
    private static final Lazy<Map<EntityType, Boolean>> IS_CHESTABLE_CACHE = Lazy.of(() -> new EnumMap(EntityType.class));
    private static final Lazy<Map<EntityType, Boolean>> IS_LIVING_CACHE = Lazy.of(() -> new EnumMap(EntityType.class));
    private static final Lazy<Map<EntityType, Boolean>> IS_VEHICLE_CACHE = Lazy.of(() -> new EnumMap(EntityType.class));
    private static final Lazy<Map<EntityType, Boolean>> IS_PROJECTILE_CACHE = Lazy.of(() -> new EnumMap(EntityType.class));
    private static final Lazy<Map<UUID, Boolean>> IS_NPC_CACHE = Lazy.of(ConcurrentHashMap::new);

    public static void setPersistent(Entity entity, boolean persistent) {
        if (SET_PERSISTENT_AVAILABLE) {
            entity.setPersistent(persistent);
        }
    }

    public static boolean isSwimming(LivingEntity livingEntity) {
        return IS_SWIMMING_AVAILABLE && livingEntity.isSwimming();
    }

    public static int getItemHealth(@NotNull Item item) {
        return ITEM_GET_HEALTH_AVAILABLE ? item.getHealth() : 5;
    }

    public static boolean isInventoryHolder(Entity entity) {
        if (entity == null) {
            return false;
        }
        return IS_INVHOLDER_CACHE.get().computeIfAbsent(entity.getType(), entityType -> entity instanceof InventoryHolder);
    }

    public static boolean isChestableHorse(Entity entity) {
        if (entity == null) {
            return false;
        }
        return IS_CHESTABLE_CACHE.get().computeIfAbsent(entity.getType(), entityType -> entity instanceof ChestedHorse);
    }

    public static boolean isLivingEntity(Entity entity) {
        if (entity == null) {
            return false;
        }
        return IS_LIVING_CACHE.get().computeIfAbsent(entity.getType(), entityType -> entity instanceof LivingEntity);
    }

    public static boolean isVehicle(Entity entity) {
        if (entity == null) {
            return false;
        }
        return IS_VEHICLE_CACHE.get().computeIfAbsent(entity.getType(), entityType -> entity instanceof Vehicle);
    }

    public static boolean isProjectile(Entity entity) {
        if (entity == null) {
            return false;
        }
        return IS_PROJECTILE_CACHE.get().computeIfAbsent(entity.getType(), entityType -> entity instanceof Projectile);
    }

    public static boolean isNPC(Entity entity) {
        if (entity == null) {
            return false;
        }
        return IS_NPC_CACHE.get().computeIfAbsent(entity.getUniqueId(), uuid -> entity.hasMetadata("NPC"));
    }
}

