/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils;

import com.destroystokyo.paper.event.player.PlayerArmorChangeEvent;
import de.tr7zw.nbtapi.NBT;
import java.nio.charset.StandardCharsets;
import java.util.EnumMap;
import java.util.Map;
import me.xginko.aef.utils.BundleUtil;
import me.xginko.aef.utils.DataComponentUtil;
import me.xginko.aef.utils.MaterialUtil;
import me.xginko.aef.utils.models.Lazy;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.map.MapView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class ItemUtil {
    public static final boolean MAP_SET_TRACKING_POS_AVAILABLE = ReflectionUtil.hasMethod(MapView.class, "setTrackingPosition", Boolean.TYPE);
    private static final boolean USE_MINIMSG_BOOKMETA = ReflectionUtil.hasClass("net.kyori.adventure.text.minimessage.MiniMessage") && ReflectionUtil.hasMethod(MiniMessage.class, "miniMessage", new Class[0]) && ReflectionUtil.hasMethod(BookMeta.class, "pages", new Class[0]);
    private static final Lazy<Map<PlayerArmorChangeEvent.SlotType, EquipmentSlot>> EQUIPMENT_SLOT_MAP = Lazy.of(() -> {
        EnumMap<PlayerArmorChangeEvent.SlotType, EquipmentSlot> slotMap = new EnumMap<PlayerArmorChangeEvent.SlotType, EquipmentSlot>(PlayerArmorChangeEvent.SlotType.class);
        slotMap.put(PlayerArmorChangeEvent.SlotType.HEAD, EquipmentSlot.HEAD);
        slotMap.put(PlayerArmorChangeEvent.SlotType.CHEST, EquipmentSlot.CHEST);
        slotMap.put(PlayerArmorChangeEvent.SlotType.LEGS, EquipmentSlot.LEGS);
        slotMap.put(PlayerArmorChangeEvent.SlotType.FEET, EquipmentSlot.FEET);
        return slotMap;
    });

    public static EquipmentSlot getEquipmentSlot(PlayerArmorChangeEvent.SlotType slotType) {
        return EQUIPMENT_SLOT_MAP.get().getOrDefault(slotType, EquipmentSlot.HAND);
    }

    @Nullable
    public static @UnmodifiableView Iterable<ItemStack> getStoredItems(@NotNull ItemStack itemStack) {
        Object content = ItemUtil.getShulkerContent(itemStack);
        if (content != null) {
            return content;
        }
        if (BundleUtil.BUNDLES_SUPPPORTED && (content = BundleUtil.getBundleContent(itemStack)) != null) {
            return content;
        }
        if (DataComponentUtil.COMPONENTS_SUPPORTED) {
            content = DataComponentUtil.getContainerContent(itemStack);
        }
        return content;
    }

    @Nullable
    public static Inventory getShulkerContent(@NotNull ItemStack itemStack) {
        BlockStateMeta blockStateMeta;
        if (MaterialUtil.INVENTORY_HOLDERS.get().contains(itemStack.getType()) && itemStack.hasItemMeta() && (blockStateMeta = (BlockStateMeta)itemStack.getItemMeta()).hasBlockState()) {
            return ((InventoryHolder)blockStateMeta.getBlockState()).getInventory();
        }
        return null;
    }

    public static String getNBTString(ItemStack itemStack) {
        return NBT.readNbt((ItemStack)itemStack).toString();
    }

    public static int getApproximateByteSize(@Nullable ItemStack itemStack, boolean utf16) {
        if (itemStack == null || !itemStack.hasItemMeta()) {
            return 0;
        }
        Iterable<ItemStack> storedItems = ItemUtil.getStoredItems(itemStack);
        if (storedItems != null) {
            return ItemUtil.getApproximateByteSize(storedItems, utf16);
        }
        if (MaterialUtil.LECTERN_BOOKS.get().contains(itemStack.getType())) {
            return ItemUtil.getApproximateByteSize((BookMeta)itemStack.getItemMeta(), utf16);
        }
        return ItemUtil.getNBTString(itemStack).getBytes(utf16 ? StandardCharsets.UTF_16 : StandardCharsets.UTF_8).length;
    }

    public static int getApproximateByteSize(@Nullable Iterable<ItemStack> inventory, boolean utf16) {
        if (inventory == null) {
            return 0;
        }
        int collectiveSize = 0;
        for (ItemStack stack : inventory) {
            collectiveSize += ItemUtil.getApproximateByteSize(stack, utf16);
        }
        return collectiveSize;
    }

    public static int getApproximateByteSize(@NotNull BookMeta bookMeta, boolean utf16) {
        return USE_MINIMSG_BOOKMETA ? ItemUtil.getApproximateByteSizeModern(bookMeta, utf16) : ItemUtil.getApproximateByteSizeLegacy(bookMeta, utf16);
    }

    private static int getApproximateByteSizeModern(@NotNull BookMeta bookMeta, boolean utf16) {
        StringBuilder content = new StringBuilder();
        if (bookMeta.hasTitle()) {
            content.append((String)MiniMessage.miniMessage().serialize(bookMeta.title()));
        }
        if (bookMeta.hasAuthor()) {
            content.append((String)MiniMessage.miniMessage().serialize(bookMeta.author()));
        }
        if (bookMeta.hasPages()) {
            for (Component page : bookMeta.pages()) {
                content.append((String)MiniMessage.miniMessage().serialize(page));
            }
        }
        if (bookMeta.hasLore()) {
            for (Component loreLine : bookMeta.lore()) {
                content.append((String)MiniMessage.miniMessage().serialize(loreLine));
            }
        }
        return content.toString().getBytes(utf16 ? StandardCharsets.UTF_16 : StandardCharsets.UTF_8).length;
    }

    private static int getApproximateByteSizeLegacy(@NotNull BookMeta bookMeta, boolean utf16) {
        StringBuilder content = new StringBuilder();
        if (bookMeta.hasTitle()) {
            content.append(bookMeta.getTitle());
        }
        if (bookMeta.hasAuthor()) {
            content.append(bookMeta.getAuthor());
        }
        if (bookMeta.hasPages()) {
            bookMeta.getPages().forEach(content::append);
        }
        if (bookMeta.hasLore()) {
            bookMeta.getLore().forEach(content::append);
        }
        return content.toString().getBytes(utf16 ? StandardCharsets.UTF_16 : StandardCharsets.UTF_8).length;
    }

    public static void setTrackingMapPosition(@NotNull MapView mapView, boolean trackingPosition) {
        if (MAP_SET_TRACKING_POS_AVAILABLE) {
            mapView.setTrackingPosition(trackingPosition);
        }
    }

    @Nullable
    public static MapView getMapById(int id) {
        return Bukkit.getMap((int)id);
    }
}

