/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.models;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;

public class BlockRegion2D {
    private final UUID worldUID;
    private final double halfSideLength;
    private final double centerX;
    private final double centerZ;

    public BlockRegion2D(UUID worldUID, double centerX, double centerZ, double halfSideLength) {
        this.worldUID = worldUID;
        this.centerX = centerX;
        this.centerZ = centerZ;
        this.halfSideLength = halfSideLength;
    }

    public static BlockRegion2D of(UUID worldUID, double centerX, double centerZ, double halfSideLength) {
        return new BlockRegion2D(worldUID, centerX, centerZ, halfSideLength);
    }

    public static BlockRegion2D of(World world, double centerX, double centerZ, double halfSideLength) {
        return BlockRegion2D.of(world.getUID(), centerX, centerZ, halfSideLength);
    }

    public UUID getWorldUID() {
        return this.worldUID;
    }

    public double getHalfSideLength() {
        return this.halfSideLength;
    }

    public double getCenterX() {
        return this.centerX;
    }

    public double getCenterZ() {
        return this.centerZ;
    }

    public boolean contains(Location location) {
        if (!location.getWorld().getUID().equals(this.worldUID)) {
            return false;
        }
        return location.getX() >= this.centerX - this.halfSideLength && location.getX() <= this.centerX + this.halfSideLength && location.getZ() >= this.centerZ - this.halfSideLength && location.getZ() <= this.centerZ + this.halfSideLength;
    }

    public boolean equals(Object obj) {
        if (null == obj || obj.getClass() != BlockRegion2D.class) {
            return false;
        }
        BlockRegion2D blockRegion2D = (BlockRegion2D)obj;
        return blockRegion2D.worldUID.equals(this.worldUID) && blockRegion2D.centerX == this.centerX && blockRegion2D.centerZ == this.centerZ;
    }

    public int hashCode() {
        return Objects.hash(this.worldUID, this.centerX, this.centerZ, this.halfSideLength);
    }

    public String toString() {
        return "BlockRegion2D{ radius(half side length)=" + this.halfSideLength + ", centerX=" + this.centerX + ", centerZ=" + this.centerZ + ", worldUID=" + String.valueOf(this.worldUID) + "}";
    }
}

