/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.models;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.xginko.aef.utils.models.Disableable;
import org.bukkit.plugin.java.JavaPlugin;

public final class VersionChecker
implements Runnable,
Disableable {
    private final JavaPlugin plugin;
    private final JsonParser jsonParser;
    private final ScheduledExecutorService executorService;
    private final ScheduledFuture<?> scheduledTask;

    public VersionChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.jsonParser = new JsonParser();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.scheduledTask = this.executorService.scheduleAtFixedRate(this, 0L, 6L, TimeUnit.HOURS);
    }

    @Override
    public void disable() {
        this.scheduledTask.cancel(true);
        this.executorService.shutdownNow();
    }

    @Override
    public void run() {
        JsonArray result;
        try (InputStream is = new URL("https://api.github.com/repos/xGinko/AnarchyExploitFixes/releases").openStream();
             InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            result = this.jsonParser.parse((Reader)reader).getAsJsonArray();
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Couldn't check GitHub for release updates! - " + e.getMessage());
            return;
        }
        LinkedHashMap versionMap = new LinkedHashMap();
        result.forEach(element -> versionMap.put(element.getAsJsonObject().get("tag_name").getAsString(), element.getAsJsonObject().get("html_url").getAsString()));
        LinkedList versionList = new LinkedList(versionMap.keySet());
        String currentVersion = "v" + this.plugin.getDescription().getVersion();
        if (((String)versionList.get(0)).equals(currentVersion)) {
            return;
        }
        if (versionList.contains(currentVersion.replace("-SNAPSHOT", ""))) {
            this.plugin.getLogger().warning("There is a new version available: " + (String)versionList.get(0) + ". You are running: " + currentVersion);
            this.plugin.getLogger().warning("Download the latest release from GitHub at the link below:");
            this.plugin.getLogger().warning((String)versionMap.get(versionList.get(0)));
        } else if (!currentVersion.contains("SNAPSHOT")) {
            this.plugin.getLogger().warning("Running an UNKNOWN release version.");
            this.plugin.getLogger().warning("If you've changed the version yourself, you can ignore this.");
            this.plugin.getLogger().warning("Otherwise, you should verify the source of the jar.");
        }
        versionMap.clear();
        versionList.clear();
    }
}

