/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.permissions;

import java.time.Duration;
import me.xginko.aef.utils.EntityUtil;
import me.xginko.aef.utils.enums.TriState;
import me.xginko.aef.utils.permissions.BukkitPermissionHandler;
import me.xginko.aef.utils.permissions.PermissionHandler;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.model.user.User;
import net.luckperms.api.node.Node;
import net.luckperms.api.util.Tristate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

public final class LuckPermsPermissionHandler
implements PermissionHandler {
    private final LuckPerms luckPerms;
    private final BukkitPermissionHandler bukkitPermissionHandler;
    private final boolean isCitizensInstalled;

    LuckPermsPermissionHandler(JavaPlugin plugin, Duration cacheDuration) {
        this.luckPerms = (LuckPerms)plugin.getServer().getServicesManager().getRegistration(LuckPerms.class).getProvider();
        this.isCitizensInstalled = plugin.getServer().getPluginManager().getPlugin("Citizens") != null;
        this.bukkitPermissionHandler = new BukkitPermissionHandler(plugin, cacheDuration);
    }

    @Override
    public void disable() {
        this.bukkitPermissionHandler.disable();
    }

    @Override
    public TriState permissionValue(Permissible permissible, String permission) {
        if (!(permissible instanceof Player) || this.isCitizensInstalled && EntityUtil.isNPC((Entity)((Player)permissible))) {
            return this.bukkitPermissionHandler.permissionValue(permissible, permission);
        }
        Tristate permState = this.luckPerms.getPlayerAdapter(Player.class).getUser((Object)((Player)permissible)).getCachedData().getPermissionData().checkPermission(permission);
        if (permState == Tristate.TRUE) {
            return TriState.TRUE;
        }
        if (permState == Tristate.FALSE) {
            return TriState.FALSE;
        }
        return TriState.UNDEFINED;
    }

    @Override
    public void setPermission(Permissible permissible, String permission, TriState state) {
        if (!(permissible instanceof Player) || this.isCitizensInstalled && EntityUtil.isNPC((Entity)((Player)permissible))) {
            this.bukkitPermissionHandler.setPermission(permissible, permission, state);
            return;
        }
        User luckPermsUser = this.luckPerms.getPlayerAdapter(Player.class).getUser((Object)((Player)permissible));
        if (state == TriState.UNDEFINED) {
            luckPermsUser.data().remove((Node)Node.builder((String)permission).build());
        } else {
            luckPermsUser.data().add((Node)Node.builder((String)permission).value(state.toBoolean()).build());
        }
        this.luckPerms.getUserManager().saveUser(luckPermsUser);
    }
}

