/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.reflection;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import me.xginko.aef.utils.models.Lazy;
import org.bukkit.Bukkit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.reflection.qual.ForName;

public final class ReflectionUtil {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final String PREFIX_NMS = "net.minecraft.server";
    public static final String PREFIX_CRAFTBUKKIT = "org.bukkit.craftbukkit";
    public static final String CRAFT_SERVER = "CraftServer";
    public static final @Nullable String VERSION;
    public static final Lazy<Class<?>> CRAFT_SERVER_CLASS;
    public static final Lazy<Class<?>> MC_SERVER_CLASS;
    public static final Lazy<Object> MC_SERVER_INSTANCE;

    public static @NonNull Class<?> needNMSClassOrElse(@NonNull String nms, String ... classNames) throws RuntimeException {
        Class<?> nmsClass = ReflectionUtil.findNmsClass(nms);
        if (nmsClass != null) {
            return nmsClass;
        }
        for (String name : classNames) {
            Class<?> maybe = ReflectionUtil.findClass(name);
            if (maybe == null) continue;
            return maybe;
        }
        throw new IllegalStateException(String.format("Couldn't find a class! NMS: '%s' or '%s'.", nms, Arrays.toString(classNames)));
    }

    @ForName
    public static @Nullable Class<?> findClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean hasClass(@NonNull String className) {
        return ReflectionUtil.findClass(className) != null;
    }

    public static @Nullable MethodHandle findMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findVirtual(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static @Nullable MethodHandle findStaticMethod(@Nullable Class<?> holderClass, String methodName, @Nullable Class<?> returnClass, Class<?> ... parameterClasses) {
        if (holderClass == null || returnClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findStatic(holderClass, methodName, MethodType.methodType(returnClass, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static boolean hasField(@Nullable Class<?> holderClass, String name, Class<?> type) {
        if (holderClass == null) {
            return false;
        }
        try {
            Field field = holderClass.getDeclaredField(name);
            return field.getType() == type;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean hasMethod(@Nullable Class<?> holderClass, String methodName, Class<?> ... parameterClasses) {
        if (holderClass == null) {
            return false;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return false;
        }
        try {
            holderClass.getMethod(methodName, parameterClasses);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static @Nullable MethodHandle findConstructor(@Nullable Class<?> holderClass, Class<?> ... parameterClasses) {
        if (holderClass == null) {
            return null;
        }
        for (Class<?> parameterClass : parameterClasses) {
            if (parameterClass != null) continue;
            return null;
        }
        try {
            return LOOKUP.findConstructor(holderClass, MethodType.methodType(Void.TYPE, parameterClasses));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return null;
        }
    }

    public static @NonNull Field needField(@NonNull Class<?> holderClass, @NonNull String fieldName) {
        try {
            Field field = holderClass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(String.format("Unable to find field '%s' in class '%s'", fieldName, holderClass.getCanonicalName()), e);
        }
    }

    public static @Nullable Field findField(@Nullable Class<?> holderClass, @NonNull String fieldName) {
        return ReflectionUtil.findField(holderClass, fieldName, null);
    }

    public static @Nullable Field findField(@Nullable Class<?> holderClass, @NonNull String fieldName, @Nullable Class<?> expectedType) {
        Field field;
        if (holderClass == null) {
            return null;
        }
        try {
            field = holderClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
        field.setAccessible(true);
        if (expectedType != null && !expectedType.isAssignableFrom(field.getType())) {
            return null;
        }
        return field;
    }

    public static @Nullable MethodHandle findSetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static @Nullable MethodHandle findGetterOf(@Nullable Field field) {
        if (field == null) {
            return null;
        }
        try {
            return LOOKUP.unreflectGetter(field);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static @Nullable Object findEnum(@Nullable Class<?> enumClass, @NonNull String enumName) {
        return ReflectionUtil.findEnum(enumClass, enumName, Integer.MAX_VALUE);
    }

    public static @Nullable Object findEnum(@Nullable Class<?> enumClass, @NonNull String enumName, int enumFallbackOrdinal) {
        if (enumClass == null || !Enum.class.isAssignableFrom(enumClass)) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] constants = enumClass.getEnumConstants();
            if (constants.length > enumFallbackOrdinal) {
                return constants[enumFallbackOrdinal];
            }
            return null;
        }
    }

    public static boolean isCraftBukkit() {
        return VERSION != null;
    }

    public static @Nullable String findCraftClassName(@NonNull String className) {
        return ReflectionUtil.isCraftBukkit() ? PREFIX_CRAFTBUKKIT + VERSION + className : null;
    }

    @ForName
    public static @Nullable Class<?> findCraftClass(@NonNull String className) {
        String craftClassName = ReflectionUtil.findCraftClassName(className);
        if (craftClassName == null) {
            return null;
        }
        return ReflectionUtil.findClass(craftClassName);
    }

    @ForName
    public static <T> @Nullable Class<? extends T> findCraftClass(@NonNull String className, @NonNull Class<T> superClass) {
        Class<?> craftClass = ReflectionUtil.findCraftClass(className);
        if (craftClass == null || !Objects.requireNonNull(superClass, "superClass").isAssignableFrom(craftClass)) {
            return null;
        }
        return craftClass.asSubclass(superClass);
    }

    @ForName
    public static @NonNull Class<?> needCraftClass(@NonNull String className) {
        return Objects.requireNonNull(ReflectionUtil.findCraftClass(className), "Could not find org.bukkit.craftbukkit class " + className);
    }

    public static @Nullable String findNmsClassName(@NonNull String className) {
        return ReflectionUtil.isCraftBukkit() ? PREFIX_NMS + VERSION + className : null;
    }

    @ForName
    public static @Nullable Class<?> findNmsClass(@NonNull String className) {
        String nmsClassName = ReflectionUtil.findNmsClassName(className);
        if (nmsClassName == null) {
            return null;
        }
        return ReflectionUtil.findClass(nmsClassName);
    }

    @ForName
    public static @NonNull Class<?> needNMSClass(@NonNull String className) {
        return Objects.requireNonNull(ReflectionUtil.findNmsClass(className), "Could not find net.minecraft.server class " + className);
    }

    public static @NonNull MethodHandles.Lookup lookup() {
        return LOOKUP;
    }

    public static @NonNull MethodHandle needStaticMethod(@NonNull Class<?> holderClass, @NonNull String methodName, @NonNull Class<?> returnClass, Class<?> ... parameterClasses) {
        return Objects.requireNonNull(ReflectionUtil.findStaticMethod(holderClass, methodName, returnClass, parameterClasses), String.format("Could not locate static method '%s' in class '%s'", methodName, holderClass.getCanonicalName()));
    }

    public static @Nullable Object invokeOrThrow(@NonNull MethodHandle methodHandle, Object ... params) {
        try {
            if (params.length == 0) {
                return methodHandle.invoke();
            }
            return methodHandle.invokeWithArguments(params);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(String.format("Unable to invoke method with args '%s'", Arrays.toString(params)), throwable);
        }
    }

    static {
        Class serverClass = Bukkit.getServer().getClass();
        if (!serverClass.getSimpleName().equals(CRAFT_SERVER)) {
            VERSION = null;
        } else if (serverClass.getName().equals("org.bukkit.craftbukkit.CraftServer")) {
            VERSION = ".";
        } else {
            String name = serverClass.getName();
            name = name.substring(PREFIX_CRAFTBUKKIT.length());
            VERSION = name = name.substring(0, name.length() - CRAFT_SERVER.length());
        }
        CRAFT_SERVER_CLASS = Lazy.of(() -> ReflectionUtil.needCraftClass(CRAFT_SERVER));
        MC_SERVER_CLASS = Lazy.of(() -> ReflectionUtil.needNMSClassOrElse("MinecraftServer", "net.minecraft.server.MinecraftServer"));
        MC_SERVER_INSTANCE = Lazy.of(() -> ReflectionUtil.invokeOrThrow(ReflectionUtil.needStaticMethod(MC_SERVER_CLASS.get(), "getServer", MC_SERVER_CLASS.get(), new Class[0]), new Object[0]));
    }
}

