/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.tickdata;

import java.time.Duration;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.utils.reflection.TickTimesReflection;
import me.xginko.aef.utils.tickdata.TickReporter;

public final class FallbackTickReporter
implements TickReporter {
    private final Cache<Boolean, Double> cache;
    private final TickTimesReflection tickTimesReflection;

    public FallbackTickReporter(Duration cacheDuration) {
        this.cache = Caffeine.newBuilder().expireAfterWrite(cacheDuration).build();
        this.tickTimesReflection = TickTimesReflection.get();
    }

    @Override
    public void disable() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Override
    public double getGlobalTPS() {
        return this.cache.get(true, k -> this.tickTimesReflection.getTPS()[0]);
    }

    @Override
    public double getTPS() {
        return this.getGlobalTPS();
    }

    @Override
    public double getGlobalMSPT() {
        return this.cache.get(false, k -> this.tickTimesReflection.getAverageTickTime());
    }

    @Override
    public double getMSPT() {
        return this.getGlobalMSPT();
    }
}

