/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.tickdata;

import io.papermc.paper.threadedregions.RegionizedServer;
import io.papermc.paper.threadedregions.ThreadedRegionizer;
import io.papermc.paper.threadedregions.TickRegionScheduler;
import io.papermc.paper.threadedregions.TickRegions;
import java.time.Duration;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import me.xginko.aef.utils.tickdata.TickReporter;

public final class FoliaTickReporter
implements TickReporter {
    private final Cache<TickRegionScheduler.RegionScheduleHandle, Double> tps_cache;
    private final Cache<TickRegionScheduler.RegionScheduleHandle, Double> mspt_cache;

    public FoliaTickReporter(Duration cacheTime) {
        this.tps_cache = Caffeine.newBuilder().expireAfterWrite(cacheTime).build();
        this.mspt_cache = Caffeine.newBuilder().expireAfterWrite(cacheTime).build();
    }

    public static boolean isSupported() {
        return ReflectionUtil.hasClass("io.papermc.paper.threadedregions.RegionizedServer") && ReflectionUtil.hasClass("io.papermc.paper.threadedregions.ThreadedRegionizer") && ReflectionUtil.hasClass("io.papermc.paper.threadedregions.TickRegionScheduler") && ReflectionUtil.hasClass("io.papermc.paper.threadedregions.TickRegions");
    }

    @Override
    public void disable() {
        this.tps_cache.invalidateAll();
        this.tps_cache.cleanUp();
        this.mspt_cache.invalidateAll();
        this.mspt_cache.cleanUp();
    }

    @Override
    public double getGlobalTPS() {
        return this.tps_cache.get(RegionizedServer.getGlobalTickData(), regionScheduleHandle -> regionScheduleHandle.getTickReport5s(System.nanoTime()).tpsData().segmentAll().average());
    }

    @Override
    public double getTPS() {
        ThreadedRegionizer.ThreadedRegion region = TickRegionScheduler.getCurrentRegion();
        if (region == null) {
            return this.getGlobalTPS();
        }
        return this.tps_cache.get(((TickRegions.TickRegionData)region.getData()).getRegionSchedulingHandle(), regionScheduleHandle -> regionScheduleHandle.getTickReport5s(System.nanoTime()).tpsData().segmentAll().average());
    }

    @Override
    public double getGlobalMSPT() {
        return this.mspt_cache.get(RegionizedServer.getGlobalTickData(), regionScheduleHandle -> regionScheduleHandle.getTickReport5s(System.nanoTime()).timePerTickData().segmentAll().average() / 1000000.0);
    }

    @Override
    public double getMSPT() {
        ThreadedRegionizer.ThreadedRegion region = TickRegionScheduler.getCurrentRegion();
        if (region == null) {
            return this.getGlobalMSPT();
        }
        return this.mspt_cache.get(((TickRegions.TickRegionData)region.getData()).getRegionSchedulingHandle(), regionScheduleHandle -> regionScheduleHandle.getTickReport5s(System.nanoTime()).timePerTickData().segmentAll().average() / 1000000.0);
    }
}

