/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.tickdata;

import java.time.Duration;
import me.xginko.aef.libs.caffeine.cache.Cache;
import me.xginko.aef.libs.caffeine.cache.Caffeine;
import me.xginko.aef.utils.reflection.ReflectionUtil;
import me.xginko.aef.utils.reflection.TickTimesReflection;
import me.xginko.aef.utils.tickdata.TickReporter;
import org.bukkit.Server;
import org.bukkit.plugin.java.JavaPlugin;

public final class LegacyPaperTickReporter
implements TickReporter {
    private final Server server;
    private final Cache<Boolean, Double> cache;
    private final TickTimesReflection tickTimesReflection;

    public LegacyPaperTickReporter(JavaPlugin plugin, Duration cacheDuration) {
        this.server = plugin.getServer();
        this.cache = Caffeine.newBuilder().expireAfterWrite(cacheDuration).build();
        this.tickTimesReflection = TickTimesReflection.get();
    }

    public static boolean isSupported() {
        return ReflectionUtil.hasMethod(Server.class, "getTPS", new Class[0]);
    }

    @Override
    public void disable() {
        this.cache.invalidateAll();
        this.cache.cleanUp();
    }

    @Override
    public double getGlobalTPS() {
        return this.cache.get(true, k -> this.server.getTPS()[0]);
    }

    @Override
    public double getTPS() {
        return this.getGlobalTPS();
    }

    @Override
    public double getGlobalMSPT() {
        return this.cache.get(false, k -> this.tickTimesReflection.getAverageTickTime());
    }

    @Override
    public double getMSPT() {
        return this.getGlobalMSPT();
    }
}

