/*
 * Decompiled with CFR 0.152.
 */
package me.xginko.aef.utils.tickdata;

import java.time.Duration;
import me.xginko.aef.utils.models.Disableable;
import me.xginko.aef.utils.tickdata.FallbackTickReporter;
import me.xginko.aef.utils.tickdata.FoliaTickReporter;
import me.xginko.aef.utils.tickdata.LegacyPaperTickReporter;
import me.xginko.aef.utils.tickdata.ModernPaperTickReporter;
import org.bukkit.plugin.java.JavaPlugin;

public interface TickReporter
extends Disableable {
    public static TickReporter create(JavaPlugin plugin, Duration cacheDuration) {
        if (FoliaTickReporter.isSupported()) {
            return new FoliaTickReporter(cacheDuration);
        }
        if (ModernPaperTickReporter.isSupported()) {
            return new ModernPaperTickReporter(plugin, cacheDuration);
        }
        if (LegacyPaperTickReporter.isSupported()) {
            return new LegacyPaperTickReporter(plugin, cacheDuration);
        }
        return new FallbackTickReporter(cacheDuration);
    }

    public double getGlobalTPS();

    public double getTPS();

    public double getGlobalMSPT();

    public double getMSPT();
}

