/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public class PaginatedAdvancementFrame {
    public static final Codec<PaginatedAdvancementFrame> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.intRange((int)-16, (int)16).optionalFieldOf("item_offset_x", (Object)0).forGetter(PaginatedAdvancementFrame::getItemOffsetX), (App)ExtraCodecs.intRange((int)-16, (int)16).optionalFieldOf("item_offset_y", (Object)0).forGetter(PaginatedAdvancementFrame::getItemOffsetY), (App)Style.Serializer.CODEC.optionalFieldOf("style", (Object)Style.EMPTY.applyFormat(ChatFormatting.GREEN)).forGetter(PaginatedAdvancementFrame::getTitleStyle)).apply((Applicative)instance, PaginatedAdvancementFrame::new));
    protected final int itemOffsetX;
    protected final int itemOffsetY;
    protected final Style titleStyle;
    protected Component toastText;
    protected ResourceLocation textureObtained = ResourceLocation.parse((String)"todo");
    protected ResourceLocation textureUnobtained = ResourceLocation.parse((String)"todo");

    public PaginatedAdvancementFrame(int itemOffsetX, int itemOffsetY, Style titleStyle) {
        this.itemOffsetX = itemOffsetX;
        this.itemOffsetY = itemOffsetY;
        this.titleStyle = titleStyle;
        this.toastText = Component.nullToEmpty((String)"todo");
    }

    public void setIdBasedData(ResourceLocation id) {
        this.toastText = Component.translatable((String)("advancements.toast." + String.valueOf(id)));
        this.textureObtained = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("advancements/" + id.getPath() + "_obtained"));
        this.textureUnobtained = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("advancements/" + id.getPath() + "_unobtained"));
    }

    public ResourceLocation getTextureObtained() {
        return this.textureObtained;
    }

    public ResourceLocation getTextureUnobtained() {
        return this.textureUnobtained;
    }

    public Style getTitleStyle() {
        return this.titleStyle;
    }

    public Component getToastText() {
        return this.toastText;
    }

    public int getItemOffsetX() {
        return this.itemOffsetX;
    }

    public int getItemOffsetY() {
        return this.itemOffsetY;
    }
}

