/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.client;

import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class PaginatedAdvancementTabType {
    public static final int WIDTH = 28;
    public static final int HEIGHT = 32;
    protected static final ResourceLocation TOP_LEFT_TEXTURE_SELECTED = ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_left_selected");
    protected static final ResourceLocation TOP_MIDDLE_TEXTURE_SELECTED = ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_middle_selected");
    protected static final ResourceLocation TOP_LEFT_TEXTURE = ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_left");
    protected static final ResourceLocation TOP_MIDDLE_TEXTURE = ResourceLocation.withDefaultNamespace((String)"advancements/tab_above_middle");

    public static int getWidthWithSpacing() {
        return 28 + PaginatedAdvancementsClient.CONFIG.SpacingBetweenHorizontalTabs;
    }

    public static void drawBackground(GuiGraphics context, int x, int y, boolean selected, int index) {
        ResourceLocation identifier = index == 0 ? (selected ? TOP_LEFT_TEXTURE_SELECTED : TOP_LEFT_TEXTURE) : (selected ? TOP_MIDDLE_TEXTURE_SELECTED : TOP_MIDDLE_TEXTURE);
        context.blitSprite(RenderPipelines.GUI_TEXTURED, identifier, x + PaginatedAdvancementTabType.getTabX(index), y + PaginatedAdvancementTabType.getTabY(), 28, 32);
    }

    public static void drawIcon(GuiGraphics context, int x, int y, int index, ItemStack stack) {
        int i = x + PaginatedAdvancementTabType.getTabX(index) + 6;
        int j = y + PaginatedAdvancementTabType.getTabY() + 9;
        context.renderFakeItem(stack, i, j);
    }

    public static int getTabX(int index) {
        return PaginatedAdvancementTabType.getWidthWithSpacing() * index;
    }

    public static int getTabY() {
        return -28;
    }

    public static boolean isClickOnTab(int screenX, int screenY, int index, double mouseX, double mouseY) {
        int i = screenX + PaginatedAdvancementTabType.getTabX(index);
        int j = screenY + PaginatedAdvancementTabType.getTabY();
        return mouseX > (double)i && mouseX < (double)(i + 28) && mouseY > (double)j && mouseY < (double)(j + 32);
    }
}

