/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.frames.FrameWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameDataLoader
extends SimpleJsonResourceReloadListener<List<Entry>> {
    public static final String LOCATION = "advancement_frames";
    public static final ResourceLocation ID = PaginatedAdvancementsClient.locate("advancement_frames");
    public static final AdvancementFrameDataLoader INSTANCE = new AdvancementFrameDataLoader();
    protected static final Map<ResourceLocation, FrameWrapper> CUSTOM_FRAMES = new HashMap<ResourceLocation, FrameWrapper>();

    public AdvancementFrameDataLoader() {
        super(Entry.LIST_CODEC, FileToIdConverter.json((String)LOCATION));
    }

    @Nullable
    public static FrameWrapper get(ResourceLocation id) {
        return CUSTOM_FRAMES.getOrDefault(id, null);
    }

    protected Map<ResourceLocation, List<Entry>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        return super.prepare(resourceManager, profiler);
    }

    protected void apply(Map<ResourceLocation, List<Entry>> prepared, ResourceManager manager, ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, List<Entry>> list : prepared.entrySet()) {
            for (Entry entry : list.getValue()) {
                ResourceLocation advancement = entry.advancementId();
                ResourceLocation frame = entry.frameId();
                @Nullable FrameWrapper frameWrapper = FrameWrapper.of(frame);
                if (frameWrapper == null) {
                    PaginatedAdvancementsClient.LOGGER.error("Advancement Frame '{}' for advancement  '{}' is unknown.", (Object)frame, (Object)advancement);
                    continue;
                }
                CUSTOM_FRAMES.put(advancement, frameWrapper);
            }
        }
    }

    public record Entry(ResourceLocation advancementId, ResourceLocation frameId) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("advancement").forGetter(Entry::advancementId), (App)ResourceLocation.CODEC.fieldOf("frame").forGetter(Entry::frameId)).apply((Applicative)instance, Entry::new));
        public static final Codec<List<Entry>> LIST_CODEC = CODEC.listOf();
    }
}

