/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import de.dafuqs.paginatedadvancements.PaginatedAdvancementsClient;
import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementFrame;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameTypeDataLoader
extends SimpleJsonResourceReloadListener<PaginatedAdvancementFrame> {
    public static final String LOCATION = "advancement_frame_types";
    public static final ResourceLocation ID = PaginatedAdvancementsClient.locate("advancement_frame_types");
    public static final AdvancementFrameTypeDataLoader INSTANCE = new AdvancementFrameTypeDataLoader();
    protected static final Map<ResourceLocation, PaginatedAdvancementFrame> ADVANCEMENT_TO_FRAME = new HashMap<ResourceLocation, PaginatedAdvancementFrame>();

    public AdvancementFrameTypeDataLoader() {
        super(PaginatedAdvancementFrame.CODEC, FileToIdConverter.json((String)LOCATION));
    }

    @Nullable
    public static PaginatedAdvancementFrame getFrameForAdvancement(ResourceLocation id) {
        return ADVANCEMENT_TO_FRAME.getOrDefault(id, null);
    }

    protected Map<ResourceLocation, PaginatedAdvancementFrame> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        return super.prepare(resourceManager, profiler);
    }

    protected void apply(Map<ResourceLocation, PaginatedAdvancementFrame> prepared, ResourceManager manager, ProfilerFiller profiler) {
        for (Map.Entry<ResourceLocation, PaginatedAdvancementFrame> entry : prepared.entrySet()) {
            ResourceLocation id = entry.getKey();
            PaginatedAdvancementFrame frame = entry.getValue();
            frame.setIdBasedData(id);
            ADVANCEMENT_TO_FRAME.put(id, frame);
        }
    }
}

