/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.paginatedadvancements.frames;

import de.dafuqs.paginatedadvancements.client.PaginatedAdvancementFrame;
import de.dafuqs.paginatedadvancements.frames.AdvancementFrameTypeDataLoader;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class FrameWrapper {
    public abstract int getItemOffsetX();

    public abstract int getItemOffsetY();

    public abstract Style getTitleStyle();

    public abstract ResourceLocation getTexture(AdvancementWidgetType var1, AdvancementType var2);

    @Nullable
    public static FrameWrapper of(ResourceLocation frame) {
        PaginatedAdvancementFrame paginatedFrame;
        String path = frame.getPath();
        if (frame.getNamespace().equals("minecraft")) {
            for (AdvancementType vanillaFrame : AdvancementType.values()) {
                if (!vanillaFrame.getSerializedName().equals(path)) continue;
                return new VanillaFrameWrapper(vanillaFrame);
            }
        }
        return (paginatedFrame = AdvancementFrameTypeDataLoader.getFrameForAdvancement(frame)) == null ? null : new PaginatedFrameWrapper(paginatedFrame);
    }

    public static class VanillaFrameWrapper
    extends FrameWrapper {
        public final AdvancementType frame;

        private VanillaFrameWrapper(AdvancementType frame) {
            this.frame = frame;
        }

        @Override
        public int getItemOffsetX() {
            return 0;
        }

        @Override
        public int getItemOffsetY() {
            return 0;
        }

        @Override
        public Style getTitleStyle() {
            return Style.EMPTY.applyFormat(this.frame.getChatColor());
        }

        @Override
        public ResourceLocation getTexture(AdvancementWidgetType status, AdvancementType vanillaFrame) {
            return status.frameSprite(this.frame);
        }
    }

    public static class PaginatedFrameWrapper
    extends FrameWrapper {
        public final PaginatedAdvancementFrame frame;

        private PaginatedFrameWrapper(PaginatedAdvancementFrame frame) {
            this.frame = frame;
        }

        @Override
        public int getItemOffsetX() {
            return this.frame.getItemOffsetX();
        }

        @Override
        public int getItemOffsetY() {
            return this.frame.getItemOffsetY();
        }

        @Override
        public Style getTitleStyle() {
            return this.frame.getTitleStyle();
        }

        @Override
        public ResourceLocation getTexture(AdvancementWidgetType status, AdvancementType vanillaFrame) {
            if (status == AdvancementWidgetType.OBTAINED) {
                return this.frame.getTextureObtained();
            }
            return this.frame.getTextureUnobtained();
        }
    }
}

