package com.mdlc.universalshortcuts.mixin;

import com.mdlc.universalshortcuts.Utils;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import org.spongepowered.asm.mixin.Mixin;


@Mixin(class_11908.class)
public abstract class KeyEventMixin implements class_11907 {
    /**
     * Remaps the key that is used by the Select All shortcut to be <kbd>A</kbd> on all keyboards.
     */
    public boolean method_74241() {
        return Utils.isKey(this.method_74228(), "A")
                && this.method_74240()
                && !this.method_74239()
                && !this.method_74238();
    }

    /**
     * Remaps the key that is used by the Copy shortcut to be <kbd>C</kbd> on all keyboards.
     */
    public boolean method_74242() {
        return Utils.isKey(this.method_74228(), "C")
                && this.method_74240()
                && !this.method_74239()
                && !this.method_74238();
    }

    /**
     * Remaps the key that is used by the Paste shortcut to be <kbd>V</kbd> on all keyboards.
     */
    public boolean method_74243() {
        return Utils.isKey(this.method_74228(), "V")
                && this.method_74240()
                && !this.method_74239()
                && !this.method_74238();
    }

    /**
     * Remaps the key that is used by the Cut shortcut to be <kbd>X</kbd> on all keyboards.
     */
    public boolean method_74244() {
        return Utils.isKey(this.method_74228(), "X")
                && this.method_74240()
                && !this.method_74239()
                && !this.method_74238();
    }
}
