/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.spellhudaddon.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1921;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.pixeldreamstudios.spellhudaddon.SpellHudState;
import net.pixeldreamstudios.spellhudaddon.config.AddonHudConfig;
import net.spell_engine.client.SpellEngineClient;
import net.spell_engine.client.gui.Drawable;
import net.spell_engine.client.gui.HudElement;
import net.spell_engine.client.gui.HudKeyVisuals;
import net.spell_engine.client.gui.HudRenderHelper;
import net.spell_engine.client.input.SpellHotbar;
import net.spell_engine.client.util.Rect;
import net.spell_engine.client.util.TextureFile;
import net.spell_engine.config.HudConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HudRenderHelper.SpellHotBarWidget.class})
public class SpellHotBarWidgetMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    private static void spellhudaddon$overrideLayout(class_332 context, int screenWidth, int screenHeight, HudRenderHelper.SpellHotBarWidget.ViewModel viewModel, CallbackInfo ci) {
        class_241 engineOffset;
        AddonHudConfig addonConfig = (AddonHudConfig)AutoConfig.getConfigHolder(AddonHudConfig.class).getConfig();
        SpellHudState.hasVisibleSpells = false;
        if (addonConfig.layout == AddonHudConfig.LayoutStyle.CENTERED_HORIZONTAL_ABOVE_HOTBAR) {
            List spells = viewModel.spells();
            if (spells.isEmpty()) {
                return;
            }
            SpellHudState.hasVisibleSpells = true;
            SpellHotBarWidgetMixin.renderCenteredHorizontalLayout(context, screenWidth, screenHeight, viewModel);
            ci.cancel();
            return;
        }
        if (addonConfig.layout == AddonHudConfig.LayoutStyle.HORIZONTAL) {
            return;
        }
        addonConfig.hotbar.offset = engineOffset = ((HudConfig)SpellEngineClient.hudConfig.value).hotbar.offset;
        List spells = viewModel.spells();
        if (spells.isEmpty()) {
            return;
        }
        SpellHudState.hasVisibleSpells = true;
        if (addonConfig.layout == AddonHudConfig.LayoutStyle.CIRCULAR_CLOCKWISE || addonConfig.layout == AddonHudConfig.LayoutStyle.CIRCULAR_COUNTERCLOCKWISE) {
            SpellHotBarWidgetMixin.renderCircularLayout(context, screenWidth, screenHeight, viewModel, addonConfig.layout);
            ci.cancel();
            return;
        }
        if (addonConfig.layout == AddonHudConfig.LayoutStyle.ROTATING_CORNER_RING) {
            SpellHotBarWidgetMixin.renderRotatingCornerHalves(context, screenWidth, screenHeight, viewModel);
            ci.cancel();
            return;
        }
        SpellHotBarWidgetMixin.renderCustomLayout(context, screenWidth, screenHeight, viewModel, addonConfig.layout);
        ci.cancel();
    }

    private static void renderCenteredHorizontalLayout(class_332 context, int screenWidth, int screenHeight, HudRenderHelper.SpellHotBarWidget.ViewModel viewModel) {
        Rect bounds;
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        AddonHudConfig config = (AddonHudConfig)AutoConfig.getConfigHolder(AddonHudConfig.class).getConfig();
        List spells = viewModel.spells();
        if (spells.isEmpty()) {
            return;
        }
        int leftWidth = 6;
        int centerWidth = 10;
        int rightWidth = 11;
        int slotWidth = leftWidth + centerWidth + rightWidth - 6;
        int slotHeight = 22;
        int iconSize = 16;
        int totalWidth = spells.size() * slotWidth;
        boolean isCreative = class_310.method_1551().field_1761 != null && class_310.method_1551().field_1761.method_2920().method_8386();
        int creativeOffset = isCreative ? 24 : 0;
        int baseY = screenHeight - slotHeight - creativeOffset;
        class_241 origin = new class_241((float)(screenWidth - totalWidth) / 2.0f, (float)baseY);
        class_241 iconOffset = new class_241(3.0f, 3.0f);
        TextureFile background = new TextureFile(class_2960.method_60654((String)"textures/gui/sprites/hud/hotbar.png"), 182, 22);
        HudRenderHelper.SpellHotBarWidget.lastRendered = bounds = new Rect(origin, origin.method_35586(new class_241((float)totalWidth, (float)slotHeight)));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < spells.size(); ++i) {
            HudRenderHelper.SpellHotBarWidget.SpellViewModel spell = (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(i);
            int slotX = (int)origin.field_1343 + i * slotWidth;
            int slotY = (int)origin.field_1342;
            context.method_25290(background.id(), slotX, slotY, 0.0f, 0.0f, leftWidth, slotHeight, background.width(), background.height());
            context.method_25290(background.id(), slotX + leftWidth, slotY, 10.0f, 0.0f, centerWidth, slotHeight, background.width(), background.height());
            context.method_25290(background.id(), slotX + leftWidth + centerWidth - 6, slotY, 170.0f, 0.0f, rightWidth, slotHeight, background.width(), background.height());
            int iconX = slotX + (int)iconOffset.field_1343;
            int iconY = slotY + (int)iconOffset.field_1342;
            if (spell.iconId() != null) {
                context.method_25290(spell.iconId(), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            } else if (spell.itemStack() != null) {
                context.method_51427(spell.itemStack(), iconX, iconY);
            }
            if (spell.cooldown() > 0.0f) {
                int k = iconY + (int)((float)iconSize * (1.0f - spell.cooldown()));
                int l = iconY + iconSize;
                context.method_51739(class_1921.method_51785(), iconX, k, iconX + iconSize, l, Integer.MAX_VALUE);
            }
            HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel kb = spell.keybinding();
            HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel mod = spell.modifier();
            int keyX = slotX + slotWidth / 2;
            int keyY = slotY + 8;
            if (kb == null) continue;
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            if (mod != null) {
                int spacing = 1;
                int modWidth = mod.width(textRenderer);
                int keyWidth = kb.width(textRenderer);
                int total = modWidth + keyWidth + spacing;
                int left = keyX - total / 2;
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, mod, left, keyY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, left + modWidth + spacing, keyY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
            } else {
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, keyX, keyY, Drawable.Anchor.CENTER, Drawable.Anchor.TRAILING);
            }
            context.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void renderCircularLayout(class_332 context, int screenWidth, int screenHeight, HudRenderHelper.SpellHotBarWidget.ViewModel viewModel, AddonHudConfig.LayoutStyle layout) {
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        AddonHudConfig config = (AddonHudConfig)AutoConfig.getConfigHolder(AddonHudConfig.class).getConfig();
        List spells = viewModel.spells();
        if (spells.isEmpty()) {
            return;
        }
        class_241 center = config.hotbar.origin.getPoint(screenWidth, screenHeight).method_35586(config.hotbar.offset);
        int radius = 50;
        int slotSize = 22;
        int iconSize = 16;
        class_241 iconOffset = new class_241(3.0f, 3.0f);
        TextureFile background = new TextureFile(class_2960.method_60654((String)"textures/gui/sprites/hud/hotbar.png"), 182, 22);
        HudRenderHelper.SpellHotBarWidget.lastRendered = new Rect(center.method_35586(new class_241((float)(-radius - slotSize), (float)(-radius - slotSize))), center.method_35586(new class_241((float)(radius + slotSize), (float)(radius + slotSize))));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < spells.size(); ++i) {
            int slotY;
            int slotX;
            HudRenderHelper.SpellHotBarWidget.SpellViewModel spell = (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(i);
            if (i == 0) {
                slotX = (int)center.field_1343 - slotSize / 2;
                slotY = (int)center.field_1342 - slotSize / 2;
            } else {
                float angleStep = (float)(Math.PI * 2 / (double)(spells.size() - 1));
                float angle = (float)(i - 1) * angleStep;
                if (layout == AddonHudConfig.LayoutStyle.CIRCULAR_COUNTERCLOCKWISE) {
                    angle = -angle;
                }
                float xOffset = (float)Math.cos(angle) * (float)radius;
                float yOffset = (float)Math.sin(angle) * (float)radius;
                slotX = (int)(center.field_1343 + xOffset - (float)(slotSize / 2));
                slotY = (int)(center.field_1342 + yOffset - (float)(slotSize / 2));
            }
            context.method_25290(background.id(), slotX, slotY, 0.0f, 0.0f, 6, slotSize, background.width(), background.height());
            context.method_25290(background.id(), slotX + 6, slotY, 10.0f, 0.0f, 10, slotSize, background.width(), background.height());
            context.method_25290(background.id(), slotX + 10, slotY, 170.0f, 0.0f, 11, slotSize, background.width(), background.height());
            int iconX = slotX + 3;
            int iconY = slotY + 3;
            if (spell.iconId() != null) {
                context.method_25290(spell.iconId(), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            } else if (spell.itemStack() != null) {
                context.method_51427(spell.itemStack(), iconX, iconY);
            }
            if (spell.cooldown() > 0.0f) {
                int k = iconY + (int)((float)iconSize * (1.0f - spell.cooldown()));
                int l = iconY + iconSize;
                context.method_51739(class_1921.method_51785(), iconX, k, iconX + iconSize, l, Integer.MAX_VALUE);
            }
            HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel kb = spell.keybinding();
            HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel mod = spell.modifier();
            int keyX = slotX + slotSize / 2;
            int keyY = slotY + 8;
            if (kb == null) continue;
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            if (mod != null) {
                int spacing = 1;
                int modWidth = mod.width(textRenderer);
                int keyWidth = kb.width(textRenderer);
                int total = modWidth + keyWidth + spacing;
                int left = keyX - total / 2;
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, mod, left, keyY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, left + modWidth + spacing, keyY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
            } else {
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, keyX, keyY, Drawable.Anchor.CENTER, Drawable.Anchor.TRAILING);
            }
            context.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void renderCustomLayout(class_332 context, int screenWidth, int screenHeight, HudRenderHelper.SpellHotBarWidget.ViewModel viewModel, AddonHudConfig.LayoutStyle layout) {
        class_241 drawOrigin;
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        AddonHudConfig config = (AddonHudConfig)AutoConfig.getConfigHolder(AddonHudConfig.class).getConfig();
        List spells = viewModel.spells();
        if (spells.isEmpty()) {
            return;
        }
        int leftWidth = 6;
        int centerWidth = 10;
        int rightWidth = 11;
        int slotWidth = leftWidth + centerWidth + rightWidth - 6;
        int slotHeight = 22;
        int iconSize = 16;
        class_241 base = config.hotbar.origin.getPoint(screenWidth, screenHeight);
        class_241 origin = base.method_35586(config.hotbar.offset);
        class_241 iconOffset = new class_241(3.0f, 3.0f);
        int columns = layout == AddonHudConfig.LayoutStyle.GRID_3x3_UP || layout == AddonHudConfig.LayoutStyle.GRID_3x3_DOWN ? 3 : 1;
        int rows = (int)Math.ceil((float)spells.size() / (float)columns);
        float totalWidth = columns * slotWidth;
        float totalHeight = rows * slotHeight;
        class_241 originOffset = new class_241(0.0f, 0.0f);
        if (layout == AddonHudConfig.LayoutStyle.VERTICAL_UP || layout == AddonHudConfig.LayoutStyle.GRID_3x3_UP) {
            originOffset = new class_241(0.0f, (float)(-slotHeight));
        }
        class_241 topLeft = drawOrigin = origin.method_35586(originOffset);
        class_241 bottomRight = drawOrigin.method_35586(new class_241(totalWidth, totalHeight));
        if (layout == AddonHudConfig.LayoutStyle.VERTICAL_UP || layout == AddonHudConfig.LayoutStyle.GRID_3x3_UP) {
            topLeft = topLeft.method_35586(new class_241(0.0f, -totalHeight + 22.0f));
            bottomRight = bottomRight.method_35586(new class_241(0.0f, -totalHeight + 22.0f));
        }
        HudRenderHelper.SpellHotBarWidget.lastRendered = new Rect(topLeft, bottomRight);
        TextureFile background = new TextureFile(class_2960.method_60654((String)"textures/gui/sprites/hud/hotbar.png"), 182, 22);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        for (int i = 0; i < spells.size(); ++i) {
            int keyY;
            int keyX;
            HudRenderHelper.SpellHotBarWidget.SpellViewModel spell = (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(i);
            int row = i / columns;
            int col = i % columns;
            int slotX = (int)drawOrigin.field_1343 + col * slotWidth;
            int slotY = switch (layout) {
                case AddonHudConfig.LayoutStyle.VERTICAL_UP, AddonHudConfig.LayoutStyle.GRID_3x3_UP -> (int)drawOrigin.field_1342 - row * slotHeight;
                case AddonHudConfig.LayoutStyle.VERTICAL_DOWN, AddonHudConfig.LayoutStyle.GRID_3x3_DOWN -> (int)drawOrigin.field_1342 + row * slotHeight;
                default -> (int)drawOrigin.field_1342 + row * slotHeight;
            };
            context.method_25290(background.id(), slotX, slotY, 0.0f, 0.0f, leftWidth, slotHeight, background.width(), background.height());
            context.method_25290(background.id(), slotX + leftWidth, slotY, 10.0f, 0.0f, centerWidth, slotHeight, background.width(), background.height());
            context.method_25290(background.id(), slotX + leftWidth + centerWidth - 6, slotY, 170.0f, 0.0f, rightWidth, slotHeight, background.width(), background.height());
            int iconX = slotX + (int)iconOffset.field_1343;
            int iconY = slotY + (int)iconOffset.field_1342;
            if (spell.iconId() != null) {
                context.method_25290(spell.iconId(), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            } else if (spell.itemStack() != null) {
                context.method_51427(spell.itemStack(), iconX, iconY);
            }
            if (spell.cooldown() > 0.0f) {
                int k = iconY + (int)((float)iconSize * (1.0f - spell.cooldown()));
                int l = iconY + iconSize;
                context.method_51739(class_1921.method_51785(), iconX, k, iconX + iconSize, l, Integer.MAX_VALUE);
            }
            HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel kb = spell.keybinding();
            HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel mod = spell.modifier();
            if (layout == AddonHudConfig.LayoutStyle.GRID_3x3_UP || layout == AddonHudConfig.LayoutStyle.GRID_3x3_DOWN) {
                keyX = slotX + (slotWidth / 2 + 1);
                keyY = slotY + 8;
            } else {
                keyX = slotX + (slotWidth / 2 + 1) - 3;
                keyY = slotY + 8;
                if (i == 0) {
                    --keyX;
                }
            }
            if (kb == null) continue;
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
            if (mod != null) {
                int spacing = 1;
                int modWidth = mod.width(textRenderer);
                int keyWidth = kb.width(textRenderer);
                int total = modWidth + keyWidth + spacing;
                int left = keyX - total / 2;
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, mod, left, keyY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, left + modWidth + spacing, keyY, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
            } else {
                SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, keyX, keyY, layout == AddonHudConfig.LayoutStyle.GRID_3x3_UP || layout == AddonHudConfig.LayoutStyle.GRID_3x3_DOWN ? Drawable.Anchor.CENTER : Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
            }
            context.method_51448().method_22909();
        }
        RenderSystem.disableBlend();
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private static void renderRotatingCornerHalves(class_332 context, int screenWidth, int screenHeight, HudRenderHelper.SpellHotBarWidget.ViewModel viewModel) {
        int sy;
        int sx;
        float t;
        int idx;
        int j;
        Rect bounds;
        int cdGroup;
        class_310 client = class_310.method_1551();
        class_327 textRenderer = client.field_1772;
        AddonHudConfig config = (AddonHudConfig)AutoConfig.getConfigHolder(AddonHudConfig.class).getConfig();
        List spells = viewModel.spells();
        if (spells.isEmpty()) {
            return;
        }
        SpellHudState.ensureCapacity(spells.size());
        class_241 center = config.hotbar.origin.getPoint(screenWidth, screenHeight).method_35586(config.hotbar.offset);
        float r = SpellHudState.radius;
        int slotSize = 22;
        int iconSize = 16;
        int leftWidth = 6;
        int midWidth = 10;
        int rightWidth = 11;
        TextureFile background = new TextureFile(class_2960.method_60654((String)"textures/gui/sprites/hud/hotbar.png"), 182, 22);
        int anchor = SpellHotBarWidgetMixin.anchorCornerIndex(config.hotbar.origin, center, screenWidth, screenHeight);
        SpellHudState.setAnchorCorner(anchor);
        int pressedGroup = SpellHotBarWidgetMixin.detectPressedGroup(client);
        if (pressedGroup != -1 && pressedGroup != SpellHudState.visibleGroup) {
            SpellHudState.setVisibleGroup(pressedGroup);
        }
        if ((cdGroup = SpellHotBarWidgetMixin.detectCooldownFiredGroup(spells)) != -1 && cdGroup != SpellHudState.visibleGroup) {
            SpellHudState.setVisibleGroup(cdGroup);
        }
        SpellHudState.tickRotation();
        HudRenderHelper.SpellHotBarWidget.lastRendered = bounds = new Rect(center.method_35586(new class_241(-r - (float)slotSize, -r - (float)slotSize)), center.method_35586(new class_241(r + (float)slotSize, r + (float)slotSize)));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        if (spells.size() > 0) {
            int cx = (int)center.field_1343 - slotSize / 2;
            int cy = (int)center.field_1342 - slotSize / 2;
            SpellHotBarWidgetMixin.drawSlot(context, background, cx, cy, leftWidth, midWidth, rightWidth, slotSize);
            SpellHotBarWidgetMixin.drawIconAndCooldown(context, (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(0), cx + 3, cy + 3, iconSize);
            SpellHotBarWidgetMixin.drawKeybind(context, textRenderer, (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(0), cx + slotSize / 2, cy + 8, true);
        }
        float baseCorner = SpellHotBarWidgetMixin.cornerAngleForAnchor(anchor);
        float angleA = baseCorner + SpellHudState.rotationRad;
        float angleB = angleA + (float)Math.PI;
        int[] groupA = new int[]{1, 2, 3, 4};
        int[] groupB = new int[]{5, 6, 7, 8};
        float[] offsetsDeg = new float[]{-25.0f, -8.0f, 8.0f, 25.0f};
        float cos = (float)Math.cos(angleA);
        float sin = (float)Math.sin(angleA);
        float dirX = cos;
        float dirY = sin;
        float tanX = -sin;
        float tanY = cos;
        float step = (float)slotSize + SpellHudState.tangentGap;
        float centerIdx = (float)(groupA.length - 1) * 0.5f;
        for (j = 0; j < groupA.length; ++j) {
            idx = groupA[j];
            if (idx >= spells.size()) continue;
            t = ((float)j - centerIdx) * step;
            sx = Math.round(center.field_1343 + dirX * r + tanX * t) - slotSize / 2;
            sy = Math.round(center.field_1342 + dirY * r + tanY * t) - slotSize / 2;
            SpellHotBarWidgetMixin.drawSlot(context, background, sx, sy, leftWidth, midWidth, rightWidth, slotSize);
            SpellHotBarWidgetMixin.drawIconAndCooldown(context, (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(idx), sx + 3, sy + 3, iconSize);
            SpellHotBarWidgetMixin.drawKeybind(context, textRenderer, (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(idx), sx + slotSize / 2, sy + 8, false);
        }
        cos = (float)Math.cos(angleB);
        sin = (float)Math.sin(angleB);
        dirX = cos;
        dirY = sin;
        tanX = -sin;
        tanY = cos;
        step = (float)slotSize + SpellHudState.tangentGap;
        centerIdx = (float)(groupB.length - 1) * 0.5f;
        for (j = 0; j < groupB.length; ++j) {
            idx = groupB[j];
            if (idx >= spells.size()) continue;
            t = ((float)j - centerIdx) * step;
            sx = Math.round(center.field_1343 + dirX * r + tanX * t) - slotSize / 2;
            sy = Math.round(center.field_1342 + dirY * r + tanY * t) - slotSize / 2;
            SpellHotBarWidgetMixin.drawSlot(context, background, sx, sy, leftWidth, midWidth, rightWidth, slotSize);
            SpellHotBarWidgetMixin.drawIconAndCooldown(context, (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(idx), sx + 3, sy + 3, iconSize);
            SpellHotBarWidgetMixin.drawKeybind(context, textRenderer, (HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(idx), sx + slotSize / 2, sy + 8, false);
        }
        RenderSystem.disableBlend();
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        for (int i = 0; i < spells.size() && i < SpellHudState.lastCooldowns.length; ++i) {
            SpellHudState.lastCooldowns[i] = ((HudRenderHelper.SpellHotBarWidget.SpellViewModel)spells.get(i)).cooldown();
        }
    }

    private static int detectPressedGroup(class_310 client) {
        int size = SpellHotbar.INSTANCE.slots.size();
        for (int i = 0; i < size && i < SpellHudState.lastKeyDown.length; ++i) {
            SpellHotbar.Slot slot = (SpellHotbar.Slot)SpellHotbar.INSTANCE.slots.get(i);
            class_304 kb = slot.getKeyBinding(client.field_1690);
            boolean down = kb != null && kb.method_1434();
            boolean wasDown = SpellHudState.lastKeyDown[i];
            SpellHudState.lastKeyDown[i] = down;
            if (!down || wasDown) continue;
            if (i >= 1 && i <= 4) {
                return 0;
            }
            if (i < 5 || i > 8) continue;
            return 1;
        }
        return -1;
    }

    private static int detectCooldownFiredGroup(List<HudRenderHelper.SpellHotBarWidget.SpellViewModel> spells) {
        for (int i = 1; i < spells.size() && i < SpellHudState.lastCooldowns.length; ++i) {
            float prev = SpellHudState.lastCooldowns[i];
            float now = spells.get(i).cooldown();
            if (!(prev < 0.1f) || !(now > 0.3f)) continue;
            if (i <= 4) {
                return 0;
            }
            if (i > 8) continue;
            return 1;
        }
        return -1;
    }

    private static int anchorCornerIndex(HudElement.Origin origin, class_241 pos, int sw, int sh) {
        boolean top;
        if (origin == HudElement.Origin.TOP_LEFT) {
            return 1;
        }
        if (origin == HudElement.Origin.TOP_RIGHT) {
            return 0;
        }
        if (origin == HudElement.Origin.BOTTOM_LEFT) {
            return 2;
        }
        if (origin == HudElement.Origin.BOTTOM_RIGHT) {
            return 3;
        }
        boolean left = pos.field_1343 < (float)sw * 0.5f;
        boolean bl = top = pos.field_1342 < (float)sh * 0.5f;
        if (top && !left) {
            return 0;
        }
        if (top && left) {
            return 1;
        }
        if (!top && left) {
            return 2;
        }
        return 3;
    }

    private static float cornerAngleForAnchor(int anchor) {
        if (anchor == 0) {
            return (float)Math.toRadians(135.0);
        }
        if (anchor == 1) {
            return (float)Math.toRadians(45.0);
        }
        if (anchor == 2) {
            return (float)Math.toRadians(315.0);
        }
        return (float)Math.toRadians(225.0);
    }

    private static void drawSlot(class_332 ctx, TextureFile bg, int x, int y, int leftW, int midW, int rightW, int h) {
        ctx.method_25290(bg.id(), x, y, 0.0f, 0.0f, leftW, h, bg.width(), bg.height());
        ctx.method_25290(bg.id(), x + leftW, y, 10.0f, 0.0f, midW, h, bg.width(), bg.height());
        ctx.method_25290(bg.id(), x + leftW + midW - 6, y, 170.0f, 0.0f, rightW, h, bg.width(), bg.height());
    }

    private static void drawIconAndCooldown(class_332 ctx, HudRenderHelper.SpellHotBarWidget.SpellViewModel spell, int ix, int iy, int iconSize) {
        if (spell.iconId() != null) {
            ctx.method_25290(spell.iconId(), ix, iy, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else if (spell.itemStack() != null) {
            ctx.method_51427(spell.itemStack(), ix, iy);
        }
        float cd = spell.cooldown();
        if (cd > 0.0f) {
            int k = iy + class_3532.method_15375((float)((float)iconSize * (1.0f - cd)));
            int l = iy + class_3532.method_15386((float)((float)iconSize * cd));
            ctx.method_51739(class_1921.method_51785(), ix, k, ix + iconSize, l, Integer.MAX_VALUE);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    private static void drawKeybind(class_332 context, class_327 textRenderer, HudRenderHelper.SpellHotBarWidget.SpellViewModel spell, int x, int y, boolean centerAnchor) {
        HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel kb = spell.keybinding();
        HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel mod = spell.modifier();
        if (kb == null) {
            return;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 200.0f);
        if (mod != null) {
            int spacing = 1;
            int modWidth = mod.width(textRenderer);
            int keyWidth = kb.width(textRenderer);
            int total = modWidth + keyWidth + spacing;
            int left = x - total / 2;
            SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, mod, left, y, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
            SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, left + modWidth + spacing, y, Drawable.Anchor.LEADING, Drawable.Anchor.TRAILING);
        } else {
            SpellHotBarWidgetMixin.drawKeybinding(context, textRenderer, kb, x, y, centerAnchor ? Drawable.Anchor.CENTER : Drawable.Anchor.CENTER, Drawable.Anchor.TRAILING);
        }
        context.method_51448().method_22909();
    }

    private static void drawKeybinding(class_332 context, class_327 textRenderer, HudRenderHelper.SpellHotBarWidget.KeyBindingViewModel keybinding, int x, int y, Drawable.Anchor horizontalAnchor, Drawable.Anchor verticalAnchor) {
        if (keybinding.drawable() != null) {
            keybinding.drawable().draw(context, x, y, horizontalAnchor, verticalAnchor);
        } else {
            String label = keybinding.label();
            int width = textRenderer.method_1727(label);
            int xOffset = switch (horizontalAnchor) {
                default -> throw new MatchException(null, null);
                case Drawable.Anchor.LEADING -> width / 2;
                case Drawable.Anchor.TRAILING -> -width / 2;
                case Drawable.Anchor.CENTER -> 0;
            };
            HudKeyVisuals.buttonLeading.draw(context, (x += xOffset) - width / 2, y, Drawable.Anchor.TRAILING, verticalAnchor);
            HudKeyVisuals.buttonCenter.drawFlexibleWidth(context, x - width / 2, y, width, verticalAnchor);
            HudKeyVisuals.buttonTrailing.draw(context, x + width / 2, y, Drawable.Anchor.LEADING, verticalAnchor);
            context.method_25300(textRenderer, label, x, y - 10, 0xFFFFFF);
        }
    }
}

