/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xMarkers.paper.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import nl.gjorgdy.pl3xMarkers.paper.helpers.FeedbackHelper;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.objects.InteractionResult;
import org.bukkit.Location;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class NodeListener
implements Listener {
    @EventHandler
    public void onPlaceBlock(BlockPlaceEvent event) {
        Banner banner;
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Banner && this.isLodestoneBelow((banner = (Banner)blockState).getLocation())) {
            this.onPlaceNode(banner, event.getPlayer());
        }
    }

    @EventHandler
    public void onBreakBlock(BlockBreakEvent event) {
        if (event.getBlock().getType().asBlockType() == BlockType.LODESTONE) {
            Block blockUp = event.getBlock().getLocation().clone().add(0.0, 1.0, 0.0).getBlock();
            BlockState blockState = blockUp.getState();
            if (blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                this.onBreakNode(banner, event.getPlayer());
            }
        } else {
            Banner banner;
            BlockState blockState = event.getBlock().getState();
            if (blockState instanceof Banner && this.isLodestoneBelow((banner = (Banner)blockState).getLocation())) {
                this.onBreakNode(banner, event.getPlayer());
            }
        }
    }

    private boolean isLodestoneBelow(Location location) {
        Block blockBelow = location.clone().add(0.0, -1.0, 0.0).getBlock();
        return blockBelow.getType().asBlockType() == BlockType.LODESTONE;
    }

    private void onPlaceNode(Banner banner, Player player) {
        Component name = banner.customName();
        if (name == null) {
            return;
        }
        InteractionResult result = Pl3xMarkersCore.api().addAreaPoint(banner.getLocation().getWorld().getName(), PlainTextComponentSerializer.plainText().serialize(name), banner.getBaseColor().getColor().asRGB(), banner.getLocation().getBlockX(), banner.getLocation().getBlockZ());
        FeedbackHelper.sendFeedback(result, player);
    }

    private void onBreakNode(Banner banner, Player player) {
        Component name = banner.customName();
        if (name == null) {
            return;
        }
        InteractionResult result = Pl3xMarkersCore.api().removeAreaPoint(banner.getLocation().getWorld().getName(), PlainTextComponentSerializer.plainText().serialize(name), banner.getBaseColor().getColor().asRGB(), banner.getLocation().getBlockX(), banner.getLocation().getBlockZ());
        FeedbackHelper.sendFeedback(result, player);
    }
}

