/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core;

import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.markers.layer.Layer;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.AreaMarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.IconMarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.objects.InteractionResult;
import nl.gjorgdy.pl3xmarkers.core.objects.LayerFactory;
import nl.gjorgdy.pl3xmarkers.core.registries.Layers;
import org.intellij.lang.annotations.Language;

public class Api {
    private static World getWorld(String worldIdentifier) {
        World world = (World)Pl3xMap.api().getWorldRegistry().get(worldIdentifier);
        if (world == null) {
            throw new RuntimeException("World not found " + worldIdentifier);
        }
        return world;
    }

    public void registerMarkerLayer(LayerFactory factory) {
        Pl3xMarkersCore.pl3xHandler().registerMarkerLayer(factory);
    }

    public void registerIconImage(String path, String filename, String filetype) {
        Pl3xMarkersCore.pl3xHandler().registerIconImage(path, filename, filetype);
    }

    public InteractionResult addAreaPoint(String worldIdentifier, @Language(value="HTML") String label, int color, int x, int z) {
        Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(Layers.Keys.AREAS);
        if (layer instanceof AreaMarkerLayer) {
            AreaMarkerLayer aml = (AreaMarkerLayer)layer;
            boolean added = aml.addPoint(label, color, x, z);
            return added ? new InteractionResult(InteractionResult.State.ADDED, "Added a point to area: " + label) : InteractionResult.skip();
        }
        return new InteractionResult(InteractionResult.State.FAILURE, "Could not add point to area: " + label);
    }

    public InteractionResult removeAreaPoint(String worldIdentifier, @Language(value="HTML") String label, int color, int x, int z) {
        Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(Layers.Keys.AREAS);
        if (layer instanceof AreaMarkerLayer) {
            AreaMarkerLayer aml = (AreaMarkerLayer)layer;
            boolean removed = aml.removePoint(label, color, x, z);
            return removed ? new InteractionResult(InteractionResult.State.REMOVED, "Removed a point from area: " + label) : InteractionResult.skip();
        }
        return new InteractionResult(InteractionResult.State.FAILURE, "Could not remove point from area: " + label);
    }

    public InteractionResult addNetherPortalIconMarker(String worldIdentifier, int x, int z) {
        boolean added = this.addIconMarker(worldIdentifier, Layers.Keys.NETHER_PORTALS, x, z);
        return added ? new InteractionResult(InteractionResult.State.ADDED, "Nether Portal marker added") : InteractionResult.skip();
    }

    public InteractionResult addEndGatewayIconMarker(String worldIdentifier, int x, int z) {
        boolean added = this.addIconMarker(worldIdentifier, Layers.Keys.END_GATEWAYS, x, z);
        return added ? new InteractionResult(InteractionResult.State.ADDED, "End Gateway marker added") : InteractionResult.skip();
    }

    public InteractionResult addEndPortalIconMarker(String worldIdentifier, int x, int z) {
        boolean added = this.addIconMarker(worldIdentifier, Layers.Keys.END_PORTALS, x, z);
        return added ? new InteractionResult(InteractionResult.State.ADDED, "End Portal marker added") : InteractionResult.skip();
    }

    public InteractionResult addBeaconIconMarker(String worldIdentifier, int x, int z) {
        boolean added = this.addIconMarker(worldIdentifier, Layers.Keys.BEACONS, x, z);
        return added ? new InteractionResult(InteractionResult.State.ADDED, "Beacon marker added") : InteractionResult.skip();
    }

    private boolean addIconMarker(String worldIdentifier, String layerKey, int x, int z) {
        Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(layerKey);
        if (layer instanceof IconMarkerLayer) {
            IconMarkerLayer simpleIconMarkerLayer = (IconMarkerLayer)layer;
            return simpleIconMarkerLayer.addSimpleMarker(x, z);
        }
        return false;
    }

    public InteractionResult removeNetherPortalIconMarker(String worldIdentifier, int x, int z) {
        boolean removed = this.removeIconMarker(worldIdentifier, Layers.Keys.NETHER_PORTALS, x, z);
        return removed ? new InteractionResult(InteractionResult.State.REMOVED, "Nether Portal marker removed") : InteractionResult.skip();
    }

    public InteractionResult removeEndGatewayIconMarker(String worldIdentifier, int x, int z) {
        boolean removed = this.removeIconMarker(worldIdentifier, Layers.Keys.END_GATEWAYS, x, z);
        return removed ? new InteractionResult(InteractionResult.State.REMOVED, "End Gateway marker removed") : InteractionResult.skip();
    }

    public InteractionResult removeEndPortalIconMarker(String worldIdentifier, int x, int z) {
        boolean removed = this.removeIconMarker(worldIdentifier, Layers.Keys.END_PORTALS, x, z);
        return removed ? new InteractionResult(InteractionResult.State.REMOVED, "End Portal marker removed") : InteractionResult.skip();
    }

    public InteractionResult removeBeaconIconMarker(String worldIdentifier, int x, int z) {
        boolean removed = this.removeIconMarker(worldIdentifier, Layers.Keys.BEACONS, x, z);
        return removed ? new InteractionResult(InteractionResult.State.REMOVED, "Beacon marker removed") : InteractionResult.skip();
    }

    private boolean removeIconMarker(String worldIdentifier, String layerKey, int x, int z) {
        Layer layer = (Layer)Api.getWorld(worldIdentifier).getLayerRegistry().get(layerKey);
        if (layer instanceof IconMarkerLayer) {
            IconMarkerLayer markerLayer = (IconMarkerLayer)layer;
            return markerLayer.removeMarker(x, z);
        }
        return false;
    }
}

