/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.registry.IconRegistry;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.MarkersConfig;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.objects.IconImageAddress;
import nl.gjorgdy.pl3xmarkers.core.objects.LayerFactory;
import nl.gjorgdy.pl3xmarkers.core.registries.Icons;
import nl.gjorgdy.pl3xmarkers.core.registries.Layers;

public class Pl3xMapHandler
implements EventListener {
    public void registerMarkerLayer(LayerFactory factory) {
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            if (factory.disabledFor((World)world)) {
                return;
            }
            MarkerLayer swl = factory.create((World)world);
            world.getLayerRegistry().register((Keyed)swl);
            swl.load();
        });
    }

    public void registerIconImage(String path, String filename, String filetype) {
        try {
            this.registerIconImage(new IconImageAddress(path, filename, filetype));
        }
        catch (IOException e) {
            System.out.println("Failed to register icon: " + path);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadedEvent event) {
        Layers.ALL.forEach(factory -> {
            if (factory.disabledFor(event.getWorld())) {
                return;
            }
            MarkerLayer swl = factory.create(event.getWorld());
            event.getWorld().getLayerRegistry().register((Keyed)swl);
            swl.load();
        });
    }

    @EventHandler
    public void onEnable(Pl3xMapEnabledEvent event) {
        MarkersConfig.reload();
        Icons.ALL.forEach(address -> {
            try {
                this.registerIconImage((IconImageAddress)address);
            }
            catch (IOException e) {
                System.out.println("Failed to register icon: " + String.valueOf(address));
            }
        });
    }

    private void registerIconImage(IconImageAddress address) throws IOException {
        IconRegistry iconRegistry = Pl3xMap.api().getIconRegistry();
        if (iconRegistry.has(address.fileName())) {
            return;
        }
        String path = address.path() + address.fileName() + "." + address.fileType();
        InputStream inputStream = Pl3xMapHandler.class.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + path);
        }
        BufferedImage image = ImageIO.read(inputStream);
        iconRegistry.register((Keyed)new IconImage(address.fileName(), image, address.fileType()));
    }
}

