/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventListener;
import nl.gjorgdy.pl3xmarkers.core.Api;
import nl.gjorgdy.pl3xmarkers.core.MarkersConfig;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMapHandler;
import nl.gjorgdy.pl3xmarkers.core.interfaces.IStorage;

public class Pl3xMarkersCore {
    private static boolean IS_BUKKIT = false;
    private static IStorage STORAGE = null;
    private static Api API = null;
    static Pl3xMapHandler PL3X_MAP_HANDLER = null;
    private static final ExecutorService executor = new ThreadPoolExecutor(2, 8, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000));

    public static boolean isBukkit() {
        return IS_BUKKIT;
    }

    public static boolean isFeedbackDisabled() {
        return !MarkersConfig.FEEDBACK_MESSAGES_ENABLED && !MarkersConfig.FEEDBACK_SOUNDS_ENABLED;
    }

    public static boolean areFeedbackMessagesEnabled() {
        return MarkersConfig.FEEDBACK_MESSAGES_ENABLED;
    }

    public static boolean areFeedbackSoundsEnabled() {
        return MarkersConfig.FEEDBACK_SOUNDS_ENABLED;
    }

    public static Path getMainDir() {
        return Pl3xMarkersCore.isBukkit() ? Path.of("plugins/Pl3xMarkers", new String[0]) : Path.of("config/pl3xmarkers", new String[0]);
    }

    public static Api api() {
        if (API == null) {
            API = new Api();
        }
        return API;
    }

    static Pl3xMapHandler pl3xHandler() {
        if (PL3X_MAP_HANDLER == null) {
            PL3X_MAP_HANDLER = new Pl3xMapHandler();
        }
        return PL3X_MAP_HANDLER;
    }

    public static IStorage storage() {
        if (STORAGE == null) {
            throw new RuntimeException("Failed to create/read database ");
        }
        return STORAGE;
    }

    public static void runParallel(Runnable task) {
        executor.execute(task);
    }

    public static void onInitialize(boolean isBukkit, IStorage storage) {
        STORAGE = storage;
        IS_BUKKIT = isBukkit;
    }

    public static void onStarted() {
        Pl3xMap.api().getEventRegistry().register((EventListener)Pl3xMarkersCore.pl3xHandler());
    }

    public static void onDisable() {
        Pl3xMarkersCore.storage().close();
        executor.shutdown();
    }
}

