/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.interfaces.entities;

import net.pl3x.map.core.markers.Point;
import org.jetbrains.annotations.NotNull;

public interface IPoint
extends Comparable<IPoint> {
    public int getX();

    public int getZ();

    default public double distance(@NotNull IPoint other) {
        return Math.sqrt(Math.pow(this.getX() - other.getX(), 2.0) + Math.pow(this.getZ() - other.getZ(), 2.0));
    }

    public IPoint add(int var1, int var2);

    public IPoint set(int var1, int var2);

    default public Point toPl3xPoint() {
        return new Point(this.getX(), this.getZ());
    }

    @Override
    default public int compareTo(@NotNull IPoint other) {
        return this.getX() - other.getX() + (this.getZ() - other.getZ());
    }
}

