/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.json.repositories;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.gjorgdy.pl3xmarkers.core.interfaces.IIconMarkerRepository;
import nl.gjorgdy.pl3xmarkers.core.json.entities.IconMarker;
import nl.gjorgdy.pl3xmarkers.core.json.interfaces.IJsonRepositoryData;
import nl.gjorgdy.pl3xmarkers.core.json.repositories.JsonRepository;

public class IconMarkerRepository
extends JsonRepository<Data>
implements IIconMarkerRepository<IconMarker> {
    public IconMarkerRepository(String folderPath, String fileName) {
        super(folderPath, fileName, Data.class, new Data());
    }

    @Override
    public Collection<IconMarker> getIconMarkers(String worldIdentifier, String layerKey) {
        WorldData world = (WorldData)((Data)this.data).get(worldIdentifier);
        if (world == null) {
            return Set.of();
        }
        LayerData layer = (LayerData)world.get(layerKey);
        return layer != null ? layer : Set.of();
    }

    @Override
    public IconMarker createIconMarker(String worldIdentifier, String layerKey, int x, int z) {
        IconMarker marker = new IconMarker(worldIdentifier, layerKey, x, z);
        boolean added = ((Data)this.data).add(marker);
        if (added) {
            this.markDirty();
        }
        return added ? marker : null;
    }

    @Override
    public boolean removeIconMarker(String worldIdentifier, String layerKey, int x, int z) {
        return ((Data)this.data).remove(worldIdentifier, layerKey, x, z);
    }

    public static class Data
    extends HashMap<String, WorldData>
    implements IJsonRepositoryData {
        public boolean add(IconMarker iconMarker) {
            return this.getOrCreate(iconMarker.getWorld()).getOrCreate(iconMarker.getLayer()).add(iconMarker);
        }

        public boolean remove(String worldIdentifier, String layerKey, int x, int z) {
            WorldData worldData = (WorldData)this.get(worldIdentifier);
            if (worldData == null) {
                return false;
            }
            LayerData layerData = (LayerData)worldData.get(layerKey);
            if (layerData == null) {
                return false;
            }
            return layerData.removeIf(m -> m.getX() == x && m.getZ() == z);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() || super.values().stream().allMatch(Map::isEmpty);
        }

        @Override
        public void setContext(JsonRepository<?> jsonRepository) {
            this.forEach((worldIdentifier, world) -> world.setContext((String)worldIdentifier));
        }

        public WorldData getOrCreate(String key) {
            return super.computeIfAbsent(key, k -> new WorldData());
        }

        @Override
        public void strip() {
            this.entrySet().removeIf(e -> ((WorldData)e.getValue()).isEmpty());
            this.values().forEach(WorldData::strip);
        }
    }

    public static class WorldData
    extends HashMap<String, LayerData> {
        public void strip() {
            this.entrySet().removeIf(e -> ((LayerData)e.getValue()).isEmpty());
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() || super.values().stream().allMatch(Set::isEmpty);
        }

        public LayerData getOrCreate(String key) {
            return super.computeIfAbsent(key, k -> new LayerData());
        }

        public void setContext(String worldIdentifier) {
            this.forEach((layerKey, layer) -> layer.setContext(worldIdentifier, (String)layerKey));
        }
    }

    public static class LayerData
    extends HashSet<IconMarker> {
        public void setContext(String worldIdentifier, String layerKey) {
            this.forEach(m -> m.setContext(worldIdentifier, layerKey));
        }
    }
}

