/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.json.repositories;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.concurrent.atomic.AtomicBoolean;
import nl.gjorgdy.pl3xmarkers.core.json.entities.IconMarker;
import nl.gjorgdy.pl3xmarkers.core.json.entities.Point;
import nl.gjorgdy.pl3xmarkers.core.json.interfaces.IJsonRepositoryData;
import nl.gjorgdy.pl3xmarkers.core.json.serializers.PointSerializer;

public abstract class JsonRepository<T extends IJsonRepositoryData> {
    private final Gson gson;
    private final String folderPath;
    private final String filePath;
    private final Class<T> markerClass;
    private final AtomicBoolean dirty = new AtomicBoolean(false);
    protected T data;

    public JsonRepository(String folderPath, String fileName, Class<T> markerClass, T defaultData) {
        this.gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Point.class, (Object)new PointSerializer()).registerTypeAdapter(IconMarker.class, (Object)new PointSerializer()).create();
        this.folderPath = folderPath;
        this.filePath = folderPath + "/" + fileName + ".json";
        this.markerClass = markerClass;
        this.data = defaultData;
        this.read();
    }

    public final void markDirty() {
        this.dirty.set(true);
    }

    private boolean invalidFile() throws IOException {
        File folder = new File(this.folderPath);
        boolean madeFolders = folder.mkdirs();
        File file = new File(this.filePath);
        if (file.exists()) {
            return false;
        }
        boolean madeFile = file.createNewFile();
        return !madeFolders || !madeFile;
    }

    public final void write() {
        if (!this.dirty.get()) {
            return;
        }
        try (FileWriter writer = new FileWriter(this.filePath, false);){
            if (this.invalidFile()) {
                return;
            }
            if (this.data == null || this.data.isEmpty()) {
                return;
            }
            this.data.strip();
            this.gson.toJson(this.data, (Appendable)writer);
            this.dirty.set(false);
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }

    public final void read() {
        if (this.dirty.get()) {
            return;
        }
        try {
            if (this.invalidFile()) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.filePath));
            IJsonRepositoryData jsonData = (IJsonRepositoryData)this.gson.fromJson((Reader)bufferedReader, this.markerClass);
            if (jsonData != null && !jsonData.isEmpty()) {
                jsonData.setContext(this);
                this.data = jsonData;
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

