/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.json.serializers;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IPoint;
import nl.gjorgdy.pl3xmarkers.core.json.entities.IconMarker;
import nl.gjorgdy.pl3xmarkers.core.json.entities.Point;

public class PointSerializer
implements JsonSerializer<IPoint>,
JsonDeserializer<IPoint> {
    public JsonElement serialize(IPoint src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray obj = new JsonArray();
        obj.add((Number)src.getX());
        obj.add((Number)src.getZ());
        return obj;
    }

    public IPoint deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonArray arr = json.getAsJsonArray();
        int x = arr.get(0).getAsInt();
        int z = arr.get(1).getAsInt();
        if (typeOfT.equals(Point.class)) {
            return new Point(x, z);
        }
        if (typeOfT.equals(IconMarker.class)) {
            return new IconMarker(x, z);
        }
        throw new JsonParseException("Unsupported IPoint type: " + typeOfT.getTypeName());
    }
}

