/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.layers.primitive;

import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IIconMarker;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.IconMarkerBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class IconMarkerLayer
extends MarkerLayer {
    public final String iconId;
    public final String key;
    public final String label;
    @Language(value="HTML")
    public final String tooltip;

    public IconMarkerLayer(String icon, String key, String label, @Language(value="HTML") String tooltip, @NotNull World world, int priority) {
        super(key, label, world, priority);
        this.iconId = icon;
        this.key = key;
        this.label = label;
        this.tooltip = tooltip;
    }

    @Override
    public void load() {
        Pl3xMarkersCore.storage().getIconMarkerRepository().getIconMarkers(this.getWorld().getKey(), this.key).forEach(marker -> this.addIconMarker(marker.getLocation().getX(), marker.getLocation().getZ()));
    }

    public boolean addSimpleMarker(int x, int z) {
        IIconMarker marker = Pl3xMarkersCore.storage().getIconMarkerRepository().createIconMarker(this.getWorld().getKey(), this.key, x, z);
        if (marker != null) {
            this.addIconMarker(x, z);
            return true;
        }
        return false;
    }

    public boolean removeMarker(int x, int z) {
        boolean removed = Pl3xMarkersCore.storage().getIconMarkerRepository().removeIconMarker(this.getWorld().getKey(), this.key, x, z);
        if (removed) {
            super.removeMarker(this.toMarkerKey(x, z));
        }
        return removed;
    }

    private void addIconMarker(int x, int z) {
        this.addMarker(this.createIconMarker(x, z));
    }

    protected Marker<?> createIconMarker(int x, int z) {
        return IconMarkerBuilder.newIconMarker(this.toMarkerKey(x, z), this.iconId, x, z).centerIcon(16, 16).addTooltip(this.tooltip).build();
    }
}

