/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.markers;

import java.util.List;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polygon;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.option.Fill;
import net.pl3x.map.core.markers.option.Stroke;
import nl.gjorgdy.pl3xmarkers.core.interfaces.entities.IPoint;
import nl.gjorgdy.pl3xmarkers.core.markers.MarkerBuilder;

public class AreaMarkerBuilder
extends MarkerBuilder<Polygon> {
    private AreaMarkerBuilder(Marker<Polygon> marker) {
        super(marker);
    }

    public static AreaMarkerBuilder newAreaMarker(String key, List<IPoint> points) {
        Polyline line = new Polyline(key, new Point[0]);
        points.stream().map(IPoint::toPl3xPoint).forEach(arg_0 -> ((Polyline)line).addPoint(arg_0));
        Polygon area = new Polygon(key, line);
        return new AreaMarkerBuilder((Marker<Polygon>)area);
    }

    public AreaMarkerBuilder fill(int color) {
        return this.fill(color, 96);
    }

    public AreaMarkerBuilder fill(int color, int alpha) {
        this.options.setFill(new Fill(AreaMarkerBuilder.setAlpha(color, alpha)).setEnabled(Boolean.valueOf(true)));
        return this;
    }

    public AreaMarkerBuilder stroke(int color) {
        return this.stroke(color, 2);
    }

    public AreaMarkerBuilder stroke(int color, int weight) {
        this.options.setStroke(new Stroke(weight, AreaMarkerBuilder.setAlpha(color, 255)).setEnabled(Boolean.valueOf(true)));
        return this;
    }

    public static int setAlpha(int color, int alpha) {
        return color & 0xFFFFFF | (alpha &= 0xFF) << 24;
    }
}

