/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xMarkers.paper.listeners;

import nl.gjorgdy.pl3xMarkers.paper.helpers.PortalHelper;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import org.bukkit.Location;
import org.bukkit.block.BlockType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerPortalEvent;

public class NetherPortalListener
implements Listener {
    @EventHandler
    public void onPortalTeleport(PlayerPortalEvent event) {
        if (event.getFrom().getBlock().getType().asBlockType() == BlockType.NETHER_PORTAL) {
            this.onNetherPortalTeleport(event.getFrom());
        }
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        BlockType blockType = event.getBlock().getType().asBlockType();
        Location location = event.getBlock().getLocation();
        if (blockType == BlockType.OBSIDIAN) {
            Location nearby = location.clone();
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        nearby.set((double)(location.getBlockX() + x), (double)(location.getBlockY() + y), (double)(location.getBlockZ() + z));
                        if (nearby.getBlock().getType().asBlockType() != BlockType.NETHER_PORTAL) continue;
                        Location center = PortalHelper.getNetherPortalCenter(nearby);
                        this.onNetherPortalBreak(center);
                        return;
                    }
                }
            }
        }
        if (blockType == BlockType.NETHER_PORTAL) {
            Location center = PortalHelper.getNetherPortalCenter(location);
            this.onNetherPortalBreak(center);
        }
    }

    private void onNetherPortalBreak(Location location) {
        Location center = PortalHelper.getNetherPortalCenter(location);
        Pl3xMarkersCore.api().removeNetherPortalIconMarker(location.getWorld().getName(), center.getBlockX(), center.getBlockZ());
    }

    private void onNetherPortalTeleport(Location location) {
        Location center = PortalHelper.getNetherPortalCenter(location);
        Pl3xMarkersCore.api().addNetherPortalIconMarker(location.getWorld().getName(), center.getBlockX(), center.getBlockZ());
    }
}

