/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xMarkers.paper.listeners;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import org.bukkit.Location;
import org.bukkit.block.Banner;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BlockType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class NodeListener
implements Listener {
    @EventHandler
    public void onPlaceBlock(BlockPlaceEvent event) {
        Banner banner;
        BlockState blockState = event.getBlock().getState();
        if (blockState instanceof Banner && this.isLodestoneBelow((banner = (Banner)blockState).getLocation())) {
            this.onPlaceNode(banner);
        }
    }

    @EventHandler
    public void onBreakBlock(BlockBreakEvent event) {
        if (event.getBlock().getType().asBlockType() == BlockType.LODESTONE) {
            Block blockUp = event.getBlock().getLocation().clone().add(0.0, 1.0, 0.0).getBlock();
            BlockState blockState = blockUp.getState();
            if (blockState instanceof Banner) {
                Banner banner = (Banner)blockState;
                this.onBreakNode(banner);
            }
        } else {
            Banner banner;
            BlockState blockState = event.getBlock().getState();
            if (blockState instanceof Banner && this.isLodestoneBelow((banner = (Banner)blockState).getLocation())) {
                this.onBreakNode(banner);
            }
        }
    }

    private boolean isLodestoneBelow(Location location) {
        Block blockBelow = location.clone().add(0.0, -1.0, 0.0).getBlock();
        return blockBelow.getType().asBlockType() == BlockType.LODESTONE;
    }

    private void onPlaceNode(Banner banner) {
        Component name = banner.customName();
        if (name == null) {
            return;
        }
        Pl3xMarkersCore.api().addAreaPoint(banner.getLocation().getWorld().getName(), PlainTextComponentSerializer.plainText().serialize(name), banner.getBaseColor().getColor().asRGB(), banner.getLocation().getBlockX(), banner.getLocation().getBlockZ());
    }

    private void onBreakNode(Banner banner) {
        Component name = banner.customName();
        if (name == null) {
            return;
        }
        Pl3xMarkersCore.api().removeAreaPoint(banner.getLocation().getWorld().getName(), PlainTextComponentSerializer.plainText().serialize(name), banner.getBaseColor().getColor().asRGB(), banner.getLocation().getBlockX(), banner.getLocation().getBlockZ());
    }
}

