/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.JdbcPooledConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.TableUtils;
import java.io.File;
import java.sql.SQLException;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaEntity;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaPointEntity;
import nl.gjorgdy.pl3xmarkers.core.entities.IconMarkerEntity;

public class Database {
    public Dao<IconMarkerEntity, String> markers;
    public Dao<AreaEntity, String> areas;
    public Dao<AreaPointEntity, String> areaPoints;
    private final JdbcPooledConnectionSource connection;

    public Database() throws SQLException {
        String configPath = Pl3xMarkersCore.isBukkit() ? "plugins/Pl3xMarkers" : "config/pl3xmarkers";
        String databaseFile = "markers";
        if (new File(configPath).mkdir()) {
            System.out.println("Created Pl3xMarkers config directory");
        }
        this.connection = new JdbcPooledConnectionSource("jdbc:sqlite:" + configPath + "/" + databaseFile + ".db");
        this.markers = DaoManager.createDao((ConnectionSource)this.connection, IconMarkerEntity.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connection, IconMarkerEntity.class);
        this.areas = DaoManager.createDao((ConnectionSource)this.connection, AreaEntity.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connection, AreaEntity.class);
        this.areaPoints = DaoManager.createDao((ConnectionSource)this.connection, AreaPointEntity.class);
        TableUtils.createTableIfNotExists((ConnectionSource)this.connection, AreaPointEntity.class);
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

