/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.event.EventHandler;
import net.pl3x.map.core.event.EventListener;
import net.pl3x.map.core.event.server.Pl3xMapEnabledEvent;
import net.pl3x.map.core.event.world.WorldLoadedEvent;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.registry.IconRegistry;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Icons;
import nl.gjorgdy.pl3xmarkers.core.Layers;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.objects.IconImageAddress;

public class Pl3xMapHandler
implements EventListener {
    public void registerMarkerLayer(Function<World, MarkerLayer> function) {
        Pl3xMap.api().getWorldRegistry().forEach(world -> {
            MarkerLayer swl = (MarkerLayer)((Object)((Object)function.apply((World)world)));
            if (!swl.isInWorld((World)world)) {
                return;
            }
            world.getLayerRegistry().register((Keyed)swl);
            swl.load();
        });
    }

    public void registerIconImage(String path, String filename, String filetype) {
        try {
            this.registerIconImage(new IconImageAddress(path, filename, filetype));
        }
        catch (IOException e) {
            System.out.println("Failed to register icon: " + path);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadedEvent event) {
        Layers.ALL.forEach(function -> {
            MarkerLayer swl = (MarkerLayer)((Object)((Object)function.apply(event.getWorld())));
            if (!swl.isInWorld(event.getWorld())) {
                return;
            }
            event.getWorld().getLayerRegistry().register((Keyed)swl);
            swl.load();
        });
    }

    @EventHandler
    public void onEnable(Pl3xMapEnabledEvent event) {
        Icons.ALL.forEach(address -> {
            try {
                this.registerIconImage((IconImageAddress)address);
            }
            catch (IOException e) {
                System.out.println("Failed to register icon: " + String.valueOf(address));
            }
        });
    }

    private void registerIconImage(IconImageAddress address) throws IOException {
        IconRegistry iconRegistry = Pl3xMap.api().getIconRegistry();
        if (iconRegistry.has(address.fileName())) {
            return;
        }
        String path = address.path() + address.fileName() + "." + address.fileType();
        InputStream inputStream = Pl3xMapHandler.class.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + path);
        }
        BufferedImage image = ImageIO.read(inputStream);
        iconRegistry.register((Keyed)new IconImage(address.fileName(), image, address.fileType()));
    }
}

