/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.entities;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;
import net.pl3x.map.core.markers.Point;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaEntity;
import org.jetbrains.annotations.NotNull;

@DatabaseTable(tableName="area_points")
public class AreaPointEntity
implements Comparable<AreaPointEntity> {
    @DatabaseField(columnName="id", generatedId=true)
    private int id;
    @DatabaseField(columnName="area_id", uniqueCombo=true, foreign=true, foreignAutoRefresh=true)
    private AreaEntity area;
    @DatabaseField(columnName="x", uniqueCombo=true)
    private int x;
    @DatabaseField(columnName="z", uniqueCombo=true)
    private int z;

    public AreaPointEntity() {
    }

    public AreaPointEntity(AreaEntity area, int x, int z) {
        this.area = area;
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public double distance(@NotNull AreaPointEntity other) {
        return Math.sqrt(Math.pow(this.x - other.x, 2.0) + Math.pow(this.z - other.z, 2.0));
    }

    public AreaPointEntity add(int dx, int dz) {
        return new AreaPointEntity(this.area, this.x + dx, this.z + dz);
    }

    public AreaPointEntity set(int x, int z) {
        return new AreaPointEntity(this.area, x, z);
    }

    @Override
    public int compareTo(@NotNull AreaPointEntity other) {
        return this.x - other.x + (this.z - other.z);
    }

    public String toString() {
        return this.area.getLabel() + ":" + this.x + ":" + this.z;
    }

    public Point toPl3xPoint() {
        return new Point(this.x, this.z);
    }
}

