/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.helpers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaPointEntity;

public class ConvexHull {
    private static final int maxSize = 512;
    private static final int maxRadius = 256;

    private ConvexHull() {
    }

    public static List<AreaPointEntity> calculate(List<AreaPointEntity> points) {
        if (points.isEmpty()) {
            return points;
        }
        if (points.size() < 3) {
            return ConvexHull.minimalArea(points.getFirst());
        }
        points.sort(null);
        if (points.getFirst().distance(points.getLast()) > 512.0) {
            points = ConvexHull.cluster(points);
        }
        return points.size() < 3 ? ConvexHull.minimalArea(points.getFirst()) : ConvexHull.calculateInternal(points);
    }

    private static List<AreaPointEntity> cluster(List<AreaPointEntity> points) {
        int centerX = points.stream().map(AreaPointEntity::getX).reduce(0, Integer::sum) / points.size();
        int centerZ = points.stream().map(AreaPointEntity::getZ).reduce(0, Integer::sum) / points.size();
        AreaPointEntity center = points.getFirst().set(centerX, centerZ);
        AreaPointEntity furthest = points.stream().max(Comparator.comparing(p -> p.distance(center))).orElse(points.getLast());
        if (furthest.distance(center) <= 256.0) {
            return points;
        }
        points.remove(furthest);
        return ConvexHull.cluster(points);
    }

    private static List<AreaPointEntity> calculateInternal(List<AreaPointEntity> points) {
        ArrayList<AreaPointEntity> lower = new ArrayList<AreaPointEntity>();
        for (AreaPointEntity p : points) {
            while (lower.size() >= 2 && ConvexHull.cross((AreaPointEntity)lower.get(lower.size() - 2), (AreaPointEntity)lower.getLast(), p) <= 0L) {
                lower.removeLast();
            }
            lower.add(p);
        }
        ArrayList<AreaPointEntity> upper = new ArrayList<AreaPointEntity>();
        for (int i = points.size() - 1; i >= 0; --i) {
            AreaPointEntity p = points.get(i);
            while (upper.size() >= 2 && ConvexHull.cross((AreaPointEntity)upper.get(upper.size() - 2), (AreaPointEntity)upper.getLast(), p) <= 0L) {
                upper.removeLast();
            }
            upper.add(p);
        }
        lower.removeLast();
        upper.removeLast();
        lower.addAll(upper);
        return lower;
    }

    private static List<AreaPointEntity> minimalArea(AreaPointEntity center) {
        return List.of(center.add(0, -8), center.add(8, 8), center.add(-8, 8));
    }

    private static long cross(AreaPointEntity a, AreaPointEntity b, AreaPointEntity c) {
        return (long)(b.getX() - a.getX()) * (long)(c.getZ() - a.getZ()) - (long)(b.getZ() - a.getZ()) * (long)(c.getX() - a.getX());
    }
}

