/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xmarkers.core.layers.primitive;

import com.j256.ormlite.dao.ForeignCollection;
import java.util.ArrayList;
import java.util.List;
import net.pl3x.map.core.world.World;
import nl.gjorgdy.pl3xmarkers.core.Pl3xMarkersCore;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaEntity;
import nl.gjorgdy.pl3xmarkers.core.entities.AreaPointEntity;
import nl.gjorgdy.pl3xmarkers.core.helpers.ConvexHull;
import nl.gjorgdy.pl3xmarkers.core.helpers.HtmlHelper;
import nl.gjorgdy.pl3xmarkers.core.layers.primitive.MarkerLayer;
import nl.gjorgdy.pl3xmarkers.core.markers.AreaMarkerBuilder;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class AreaMarkerLayer
extends MarkerLayer {
    public AreaMarkerLayer(String key, String label, @NotNull World world) {
        super(key, label, world);
    }

    @Override
    public void load() {
        Pl3xMarkersCore.areaRepository().getAreas(this.getWorld().getKey()).forEach(this::loadArea);
    }

    @Override
    public boolean isInWorld(@NotNull World world) {
        return true;
    }

    public void loadArea(AreaEntity area) {
        ForeignCollection<AreaPointEntity> points;
        if (super.hasMarker(area.getKey())) {
            super.removeMarker(area.getKey());
        }
        if ((points = area.getPoints()) == null || points.isEmpty()) {
            return;
        }
        List<AreaPointEntity> sortedPoints = ConvexHull.calculate(new ArrayList<AreaPointEntity>(area.getPoints()));
        if (!sortedPoints.isEmpty()) {
            super.addMarker(AreaMarkerBuilder.newAreaMarker(area.getKey(), sortedPoints).fill(area.getColor()).stroke(area.getColor()).addPopup(HtmlHelper.sanitize(area.getLabel())));
        }
    }

    public void addPoint(@Language(value="HTML") String label, int color, int x, int z) {
        AreaEntity area;
        boolean added = Pl3xMarkersCore.areaRepository().addPoint(this.getWorld().getKey(), label, color, x, z);
        if (added && (area = Pl3xMarkersCore.areaRepository().getArea(this.getWorld().getKey(), label, color)) != null) {
            this.loadArea(area);
        }
    }

    public void removePoint(@Language(value="HTML") String label, int color, int x, int z) {
        AreaEntity area;
        boolean removed = Pl3xMarkersCore.areaRepository().removePoint(this.getWorld().getKey(), label, color, x, z);
        if (removed && (area = Pl3xMarkersCore.areaRepository().getArea(this.getWorld().getKey(), label, color)) != null) {
            this.loadArea(area);
        }
    }
}

