/*
 * Decompiled with CFR 0.152.
 */
package nl.gjorgdy.pl3xMarkers.paper.helpers;

import org.bukkit.Axis;
import org.bukkit.Location;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Orientable;

public class PortalHelper {
    public static Location getNetherPortalCenter(Location location) {
        BlockData blockData = location.getBlock().getBlockData();
        if (blockData instanceof Orientable) {
            Orientable orientable = (Orientable)blockData;
            boolean isX = orientable.getAxis() == Axis.X;
            Location lowCorner = location.clone();
            while (lowCorner.getBlock().getType().asBlockType() == BlockType.NETHER_PORTAL) {
                lowCorner = lowCorner.add(isX ? -1.0 : 0.0, 0.0, isX ? 0.0 : -1.0);
            }
            Location highCorner = location.clone();
            while (highCorner.getBlock().getType().asBlockType() == BlockType.NETHER_PORTAL) {
                highCorner = highCorner.add(isX ? 1.0 : 0.0, 0.0, isX ? 0.0 : 1.0);
            }
            int deltaX = Math.abs(highCorner.getBlockX() - lowCorner.getBlockX());
            int deltaZ = Math.abs(highCorner.getBlockZ() - lowCorner.getBlockZ());
            int centerX = lowCorner.getBlockX() + deltaX / 2;
            int centerZ = lowCorner.getBlockZ() + deltaZ / 2;
            return location.clone().set((double)centerX, 0.0, (double)centerZ);
        }
        return location;
    }

    public static Location getEndPortalCenter(Location location) {
        if (location.clone().add(-1.0, 0.0, 0.0).getBlock().getType().asBlockType() != BlockType.END_PORTAL) {
            location.add(1.0, 0.0, 0.0);
        }
        if (location.clone().add(1.0, 0.0, 0.0).getBlock().getType().asBlockType() != BlockType.END_PORTAL) {
            location.add(-1.0, 0.0, 0.0);
        }
        if (location.clone().add(0.0, 0.0, -1.0).getBlock().getType().asBlockType() != BlockType.END_PORTAL) {
            location.add(0.0, 0.0, 1.0);
        }
        if (location.clone().add(0.0, 0.0, 1.0).getBlock().getType().asBlockType() != BlockType.END_PORTAL) {
            location.add(0.0, 0.0, -1.0);
        }
        return location;
    }
}

